/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.date.format;

import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.map.concurrent.SafeConcurrentHashMap;
import top.redscorpion.core.util.RsDate;

public class DateFormatManager {
    public static final String FORMAT_SECONDS = "#sss";
    public static final String FORMAT_MILLISECONDS = "#SSS";
    private final Map<CharSequence, Function<Date, String>> formatterMap = new SafeConcurrentHashMap<CharSequence, Function<Date, String>>();
    private final Map<CharSequence, Function<CharSequence, Date>> parserMap = new SafeConcurrentHashMap<CharSequence, Function<CharSequence, Date>>();

    public static DateFormatManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public DateFormatManager() {
        this.registerFormatter(FORMAT_SECONDS, date -> String.valueOf(Math.floorDiv(date.getTime(), 1000L)));
        this.registerParser(FORMAT_SECONDS, dateStr -> RsDate.date(Math.multiplyExact(Long.parseLong(dateStr.toString()), 1000L)));
        this.registerFormatter(FORMAT_MILLISECONDS, date -> String.valueOf(date.getTime()));
        this.registerParser(FORMAT_MILLISECONDS, dateStr -> RsDate.date(Long.parseLong(dateStr.toString())));
    }

    public DateFormatManager registerFormatter(String format, Function<Date, String> func) {
        Assert.notNull(format, "Format must be not null !", new Object[0]);
        Assert.notNull(func, "Function must be not null !", new Object[0]);
        this.formatterMap.put(format, func);
        return this;
    }

    public DateFormatManager registerParser(String format, Function<CharSequence, Date> func) {
        Assert.notNull(format, "Format must be not null !", new Object[0]);
        Assert.notNull(func, "Function must be not null !", new Object[0]);
        this.parserMap.put(format, func);
        return this;
    }

    public boolean isCustomFormat(String format) {
        return null != this.formatterMap && this.formatterMap.containsKey(format);
    }

    public String format(TemporalAccessor temporalAccessor, CharSequence format) {
        return this.format(RsDate.date(temporalAccessor), format);
    }

    public String format(Date date, CharSequence format) {
        Function<Date, String> func;
        if (null != this.formatterMap && null != (func = this.formatterMap.get(format))) {
            return func.apply(date);
        }
        return null;
    }

    public boolean isCustomParse(String format) {
        return null != this.parserMap && this.parserMap.containsKey(format);
    }

    public Date parse(CharSequence dateStr, String format) {
        Function<CharSequence, Date> func;
        if (null != this.parserMap && null != (func = this.parserMap.get(format))) {
            return func.apply(dateStr);
        }
        return null;
    }

    private static class SingletonHolder {
        private static final DateFormatManager INSTANCE = new DateFormatManager();

        private SingletonHolder() {
        }
    }
}

