/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.date;

import top.redscorpion.core.lang.Assert;

public enum Month {
    JANUARY(0),
    FEBRUARY(1),
    MARCH(2),
    APRIL(3),
    MAY(4),
    JUNE(5),
    JULY(6),
    AUGUST(7),
    SEPTEMBER(8),
    OCTOBER(9),
    NOVEMBER(10),
    DECEMBER(11),
    UNDECIMBER(12);

    private static final Month[] ENUMS;
    private final int value;

    private Month(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public int getValueBaseOne() {
        Assert.isFalse(this == UNDECIMBER, "Unsupported UNDECIMBER Field", new Object[0]);
        return this.getValue() + 1;
    }

    public int getLastDay(boolean isLeapYear) {
        switch (this) {
            case FEBRUARY: {
                return isLeapYear ? 29 : 28;
            }
            case APRIL: 
            case JUNE: 
            case SEPTEMBER: 
            case NOVEMBER: {
                return 30;
            }
        }
        return 31;
    }

    public static Month of(int calendarMonthIntValue) {
        if (calendarMonthIntValue >= ENUMS.length || calendarMonthIntValue < 0) {
            return null;
        }
        return ENUMS[calendarMonthIntValue];
    }

    public static Month of(String name) throws IllegalArgumentException {
        if (null != name && name.length() > 1) {
            switch (Character.toLowerCase(name.charAt(0))) {
                case 'a': {
                    switch (Character.toLowerCase(name.charAt(1))) {
                        case 'p': {
                            return APRIL;
                        }
                        case 'u': {
                            return AUGUST;
                        }
                    }
                    break;
                }
                case 'j': {
                    if (Character.toLowerCase(name.charAt(1)) == 'a') {
                        return JANUARY;
                    }
                    switch (Character.toLowerCase(name.charAt(2))) {
                        case 'n': {
                            return JUNE;
                        }
                        case 'l': {
                            return JULY;
                        }
                    }
                    break;
                }
                case 'f': {
                    return FEBRUARY;
                }
                case 'm': {
                    switch (Character.toLowerCase(name.charAt(2))) {
                        case 'r': {
                            return MARCH;
                        }
                        case 'y': {
                            return MAY;
                        }
                    }
                    break;
                }
                case 's': {
                    return SEPTEMBER;
                }
                case 'o': {
                    return OCTOBER;
                }
                case 'n': {
                    return NOVEMBER;
                }
                case 'd': {
                    return DECEMBER;
                }
                case '\u4e00': {
                    return JANUARY;
                }
                case '\u4e8c': {
                    return FEBRUARY;
                }
                case '\u4e09': {
                    return MARCH;
                }
                case '\u56db': {
                    return APRIL;
                }
                case '\u4e94': {
                    return MAY;
                }
                case '\u516d': {
                    return JUNE;
                }
                case '\u4e03': {
                    return JULY;
                }
                case '\u516b': {
                    return AUGUST;
                }
                case '\u4e5d': {
                    return SEPTEMBER;
                }
                case '\u5341': {
                    switch (Character.toLowerCase(name.charAt(1))) {
                        case '\u4e00': {
                            return NOVEMBER;
                        }
                        case '\u4e8c': {
                            return DECEMBER;
                        }
                    }
                    return OCTOBER;
                }
            }
        }
        throw new IllegalArgumentException("Invalid Month name: " + name);
    }

    static {
        ENUMS = Month.values();
    }
}

