/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.date;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import top.redscorpion.core.date.BetweenFormatter;
import top.redscorpion.core.date.DateUnit;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsCalendar;
import top.redscorpion.core.util.RsDate;

public class DateBetween
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Date begin;
    private final Date end;

    public DateBetween(Date begin, Date end) {
        this(begin, end, true);
    }

    public DateBetween(Date begin, Date end, boolean isAbs) {
        Assert.notNull(begin, "Begin date is null !", new Object[0]);
        Assert.notNull(end, "End date is null !", new Object[0]);
        if (isAbs && begin.after(end)) {
            this.begin = end;
            this.end = begin;
        } else {
            this.begin = begin;
            this.end = end;
        }
    }

    public long between(DateUnit unit) {
        long diff = this.end.getTime() - this.begin.getTime();
        return diff / unit.getMillis();
    }

    public long betweenMonth(boolean isReset) {
        Calendar beginCal = RsCalendar.calendar(this.begin);
        Calendar endCal = RsCalendar.calendar(this.end);
        int betweenYear = endCal.get(1) - beginCal.get(1);
        int betweenMonthOfYear = endCal.get(2) - beginCal.get(2);
        int result = betweenYear * 12 + betweenMonthOfYear;
        if (!isReset) {
            endCal.set(1, beginCal.get(1));
            endCal.set(2, beginCal.get(2));
            long between = endCal.getTimeInMillis() - beginCal.getTimeInMillis();
            if (between < 0L) {
                return result - 1;
            }
        }
        return result;
    }

    public String toString(DateUnit unit, BetweenFormatter.Level level) {
        return RsDate.formatBetween(this.between(unit), level);
    }

    public String toString(BetweenFormatter.Level level) {
        return this.toString(DateUnit.MS, level);
    }

    public String toString() {
        return this.toString(BetweenFormatter.Level.MILLISECOND);
    }
}

