/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.date;

import java.io.Serializable;
import java.util.function.Function;
import top.redscorpion.core.date.DateUnit;
import top.redscorpion.core.util.RsString;

public class BetweenFormatter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long betweenMs;
    private Level level;
    private final int levelMaxCount;
    private boolean simpleMode = true;
    private Function<Level, String> levelFormatter = Level::getName;
    private String separator = "";

    public static BetweenFormatter of(long betweenMs, Level level) {
        return BetweenFormatter.of(betweenMs, level, 0);
    }

    public static BetweenFormatter of(long betweenMs, Level level, int levelMaxCount) {
        return new BetweenFormatter(betweenMs, level, levelMaxCount);
    }

    public BetweenFormatter(long betweenMs, Level level, int levelMaxCount) {
        this.betweenMs = betweenMs;
        this.level = level;
        this.levelMaxCount = levelMaxCount;
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        if (this.betweenMs > 0L) {
            long day = this.betweenMs / DateUnit.DAY.getMillis();
            long hour = this.betweenMs / DateUnit.HOUR.getMillis() - day * 24L;
            long minute = this.betweenMs / DateUnit.MINUTE.getMillis() - day * 24L * 60L - hour * 60L;
            long betweenOfSecond = ((day * 24L + hour) * 60L + minute) * 60L;
            long second = this.betweenMs / DateUnit.SECOND.getMillis() - betweenOfSecond;
            long millisecond = this.betweenMs - (betweenOfSecond + second) * 1000L;
            int level = this.level.ordinal();
            int levelCount = 0;
            if (this.isLevelCountValid(levelCount) && day > 0L) {
                sb.append(day).append(this.levelFormatter.apply(Level.DAY)).append(this.separator);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && level >= Level.HOUR.ordinal() && (hour > 0L || !this.simpleMode && RsString.isNotEmpty(sb))) {
                sb.append(hour).append(this.levelFormatter.apply(Level.HOUR)).append(this.separator);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && level >= Level.MINUTE.ordinal() && (minute > 0L || !this.simpleMode && RsString.isNotEmpty(sb))) {
                sb.append(minute).append(this.levelFormatter.apply(Level.MINUTE)).append(this.separator);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && level >= Level.SECOND.ordinal() && (second > 0L || !this.simpleMode && RsString.isNotEmpty(sb))) {
                sb.append(second).append(this.levelFormatter.apply(Level.SECOND)).append(this.separator);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && millisecond > 0L && level >= Level.MILLISECOND.ordinal()) {
                sb.append(millisecond).append(this.levelFormatter.apply(Level.MILLISECOND)).append(this.separator);
            }
        }
        if (RsString.isEmpty(sb)) {
            sb.append(0).append(this.levelFormatter.apply(this.level));
        } else if (RsString.isNotEmpty(this.separator)) {
            sb.delete(sb.length() - this.separator.length(), sb.length());
        }
        return sb.toString().trim();
    }

    public long getBetweenMs() {
        return this.betweenMs;
    }

    public BetweenFormatter setBetweenMs(long betweenMs) {
        this.betweenMs = betweenMs;
        return this;
    }

    public Level getLevel() {
        return this.level;
    }

    public BetweenFormatter setLevel(Level level) {
        this.level = level;
        return this;
    }

    public BetweenFormatter setSimpleMode(boolean simpleMode) {
        this.simpleMode = simpleMode;
        return this;
    }

    public BetweenFormatter setLevelFormatter(Function<Level, String> levelFormatter) {
        this.levelFormatter = levelFormatter;
        return this;
    }

    public BetweenFormatter setSeparator(String separator) {
        this.separator = RsString.toStringOrEmpty(separator);
        return this;
    }

    public String toString() {
        return this.format();
    }

    private boolean isLevelCountValid(int levelCount) {
        return this.levelMaxCount <= 0 || levelCount < this.levelMaxCount;
    }

    public static enum Level {
        DAY("\u5929"),
        HOUR("\u5c0f\u65f6"),
        MINUTE("\u5206"),
        SECOND("\u79d2"),
        MILLISECOND("\u6beb\u79d2");

        private final String name;

        private Level(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

