/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.data;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import top.redscorpion.core.util.RsRegular;
import top.redscorpion.core.util.RsString;

public class CIN10 {
    private static final Pattern PATTERN_TW = Pattern.compile("^[a-zA-Z][0-9]{9}$");
    private static final Pattern PATTERN_MC = Pattern.compile("^[157][0-9]{6}\\(?[0-9A-Z]\\)?$");
    private static final Pattern PATTERN_HK = Pattern.compile("^[A-Z]{1,2}[0-9]{6}\\(?[0-9A]\\)?$");
    private static final Map<Character, Integer> TW_FIRST_CODE = new HashMap<Character, Integer>();
    private final String code;
    private final String province;
    private final Gender gender;
    private final boolean verified;

    public static CIN10 of(String code) {
        return new CIN10(code);
    }

    public CIN10(String code) throws IllegalArgumentException {
        this.code = code;
        if (RsString.isNotBlank(code)) {
            code = RsString.replace(code, "\uff08", "(");
            if (RsRegular.isMatch(PATTERN_TW, code = RsString.replace(code, "\uff09", ")"))) {
                this.province = "\u53f0\u6e7e";
                char char2 = code.charAt(1);
                this.gender = '1' == char2 ? Gender.MALE : ('2' == char2 ? Gender.FEMALE : Gender.UNKNOWN);
                this.verified = CIN10.verifyTWCard(code);
                return;
            }
            if (RsRegular.isMatch(PATTERN_MC, code)) {
                this.province = "\u6fb3\u95e8";
                this.gender = Gender.UNKNOWN;
                this.verified = true;
                return;
            }
            if (RsRegular.isMatch(PATTERN_HK, code)) {
                this.province = "\u9999\u6e2f";
                this.gender = Gender.UNKNOWN;
                this.verified = CIN10.verfyHKCard(code);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid CIN10 code!");
    }

    public String getCode() {
        return this.code;
    }

    public String getProvince() {
        return this.province;
    }

    public Gender getGender() {
        return this.gender;
    }

    public boolean isVerified() {
        return this.verified;
    }

    private static boolean verifyTWCard(String code) {
        Integer iStart = TW_FIRST_CODE.get(Character.valueOf(code.charAt(0)));
        if (null == iStart) {
            return false;
        }
        int sum = iStart / 10 + iStart % 10 * 9;
        String mid = code.substring(1, 9);
        char[] chars = mid.toCharArray();
        int iflag = 8;
        for (char c : chars) {
            sum += Integer.parseInt(String.valueOf(c)) * iflag;
            --iflag;
        }
        String end = code.substring(9, 10);
        return (sum % 10 == 0 ? 0 : 10 - sum % 10) == Integer.parseInt(end);
    }

    private static boolean verfyHKCard(String code) {
        int sum;
        String card = code.replaceAll("[()]", "");
        if (card.length() == 9) {
            sum = (Character.toUpperCase(card.charAt(0)) - 55) * 9 + (Character.toUpperCase(card.charAt(1)) - 55) * 8;
            card = card.substring(1, 9);
        } else {
            sum = 522 + (Character.toUpperCase(card.charAt(0)) - 55) * 8;
        }
        String mid = card.substring(1, 7);
        String end = card.substring(7, 8);
        char[] chars = mid.toCharArray();
        int iflag = 7;
        for (char c : chars) {
            sum += Integer.parseInt(String.valueOf(c)) * iflag;
            --iflag;
        }
        sum = "A".equalsIgnoreCase(end) ? (sum += 10) : (sum += Integer.parseInt(end));
        return sum % 11 == 0;
    }

    static {
        TW_FIRST_CODE.put(Character.valueOf('A'), 10);
        TW_FIRST_CODE.put(Character.valueOf('B'), 11);
        TW_FIRST_CODE.put(Character.valueOf('C'), 12);
        TW_FIRST_CODE.put(Character.valueOf('D'), 13);
        TW_FIRST_CODE.put(Character.valueOf('E'), 14);
        TW_FIRST_CODE.put(Character.valueOf('F'), 15);
        TW_FIRST_CODE.put(Character.valueOf('G'), 16);
        TW_FIRST_CODE.put(Character.valueOf('H'), 17);
        TW_FIRST_CODE.put(Character.valueOf('J'), 18);
        TW_FIRST_CODE.put(Character.valueOf('K'), 19);
        TW_FIRST_CODE.put(Character.valueOf('L'), 20);
        TW_FIRST_CODE.put(Character.valueOf('M'), 21);
        TW_FIRST_CODE.put(Character.valueOf('N'), 22);
        TW_FIRST_CODE.put(Character.valueOf('P'), 23);
        TW_FIRST_CODE.put(Character.valueOf('Q'), 24);
        TW_FIRST_CODE.put(Character.valueOf('R'), 25);
        TW_FIRST_CODE.put(Character.valueOf('S'), 26);
        TW_FIRST_CODE.put(Character.valueOf('T'), 27);
        TW_FIRST_CODE.put(Character.valueOf('U'), 28);
        TW_FIRST_CODE.put(Character.valueOf('V'), 29);
        TW_FIRST_CODE.put(Character.valueOf('X'), 30);
        TW_FIRST_CODE.put(Character.valueOf('Y'), 31);
        TW_FIRST_CODE.put(Character.valueOf('W'), 32);
        TW_FIRST_CODE.put(Character.valueOf('Z'), 33);
        TW_FIRST_CODE.put(Character.valueOf('I'), 34);
        TW_FIRST_CODE.put(Character.valueOf('O'), 35);
    }

    public static enum Gender {
        MALE,
        FEMALE,
        UNKNOWN;

    }
}

