/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import top.redscorpion.core.convert.AbstractConverterWithRoot;
import top.redscorpion.core.convert.CompositeConverter;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.convert.Converter;
import top.redscorpion.core.convert.MatcherConverter;
import top.redscorpion.core.reflect.AbstractTypeReference;
import top.redscorpion.core.util.RsBean;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsType;

public class MapConverter
extends AbstractConverterWithRoot
implements MatcherConverter,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final MapConverter INSTANCE = new MapConverter(CompositeConverter.getInstance());

    public MapConverter(Converter rootConverter) {
        super(rootConverter);
    }

    @Override
    public boolean match(Type targetType, Class<?> rawType, Object value) {
        return Map.class.isAssignableFrom(rawType);
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (targetType instanceof AbstractTypeReference) {
            targetType = ((AbstractTypeReference)targetType).getType();
        }
        Type keyType = RsType.getTypeArgument(targetType, 0);
        Type valueType = RsType.getTypeArgument(targetType, 1);
        return this.convert(targetType, keyType, valueType, value);
    }

    public Map<?, ?> convert(Type targetType, Type keyType, Type valueType, Object value) throws ConvertException {
        Map<String, Object> map;
        if (value instanceof Map) {
            Type[] typeArguments;
            Class<?> valueClass = value.getClass();
            if (valueClass.equals(targetType) && null != (typeArguments = RsType.getTypeArguments(valueClass)) && 2 == typeArguments.length && Objects.equals(keyType, typeArguments[0]) && Objects.equals(valueType, typeArguments[1])) {
                return (Map)value;
            }
            map = RsMap.createMap(RsType.getClass(targetType), LinkedHashMap::new);
            this.convertMapToMap(keyType, valueType, (Map)value, map);
        } else if (RsBean.isWritableBean(value.getClass())) {
            map = RsBean.beanToMap(value);
            map = this.convert(targetType, keyType, valueType, map);
        } else {
            throw new ConvertException("Unsupported to map from [{}] of type: {}", value, value.getClass().getName());
        }
        return map;
    }

    private void convertMapToMap(Type keyType, Type valueType, Map<?, ?> srcMap, Map targetMap) {
        srcMap.forEach((key, value) -> targetMap.put(RsType.isUnknown(keyType) ? key : this.rootConverter.convert(keyType, key), RsType.isUnknown(valueType) ? value : this.rootConverter.convert(valueType, value)));
    }
}

