/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;
import top.redscorpion.core.convert.AbstractConverterWithRoot;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.convert.Converter;
import top.redscorpion.core.convert.MatcherConverter;
import top.redscorpion.core.lang.tuple.Pair;
import top.redscorpion.core.lang.wrapper.Wrapper;
import top.redscorpion.core.reflect.AbstractTypeReference;
import top.redscorpion.core.reflect.RsConstructor;
import top.redscorpion.core.util.RsBean;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsType;

public class EntryConverter
extends AbstractConverterWithRoot
implements MatcherConverter,
Serializable {
    private static final long serialVersionUID = 1L;

    public EntryConverter(Converter converter) {
        super(converter);
    }

    @Override
    public boolean match(Type targetType, Class<?> rawType, Object value) {
        return Map.Entry.class.isAssignableFrom(rawType);
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (targetType instanceof AbstractTypeReference) {
            targetType = ((AbstractTypeReference)targetType).getType();
        }
        Type keyType = RsType.getTypeArgument(targetType, 0);
        Type valueType = RsType.getTypeArgument(targetType, 1);
        return this.convert(targetType, keyType, valueType, value);
    }

    public Map.Entry<?, ?> convert(Type targetType, Type keyType, Type valueType, Object value) throws ConvertException {
        Map<Object, Object> map = null;
        if (value instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)value;
            map = RsMap.of(entry.getKey(), entry.getValue());
        } else if (value instanceof Pair) {
            Pair entry = (Pair)value;
            map = RsMap.of(entry.getLeft(), entry.getRight());
        } else if (value instanceof Map) {
            map = (Map)value;
        } else if (value instanceof CharSequence) {
            CharSequence str = (CharSequence)value;
            map = EntryConverter.strToMap(str);
        } else if (RsBean.isWritableBean(value.getClass())) {
            map = RsBean.toBeanMap(value);
        }
        if (null != map) {
            return this.mapToEntry(targetType, keyType, valueType, map);
        }
        throw new ConvertException("Unsupported to map from [{}] of type: {}", value, value.getClass().getName());
    }

    private static Map<CharSequence, CharSequence> strToMap(CharSequence str) {
        int index = RsString.indexOf(str, c -> c.charValue() == ':' || c.charValue() == '=' || c.charValue() == ',', 0, str.length());
        if (index > -1) {
            return RsMap.of(str.subSequence(0, index), str.subSequence(index + 1, str.length()));
        }
        return null;
    }

    private Map.Entry<?, ?> mapToEntry(Type targetType, Type keyType, Type valueType, Map map) {
        Object value;
        Object key;
        if (1 == map.size()) {
            Map.Entry entry = map.entrySet().iterator().next();
            key = entry.getKey();
            value = entry.getValue();
        } else {
            key = map.get("key");
            value = map.get("value");
        }
        if (value instanceof Wrapper) {
            value = ((Wrapper)value).getRaw();
        }
        return (Map.Entry)RsConstructor.newInstance(RsType.getClass(targetType), RsType.isUnknown(keyType) ? key : this.rootConverter.convert(keyType, key), RsType.isUnknown(valueType) ? value : this.rootConverter.convert(valueType, value));
    }
}

