/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collection;
import top.redscorpion.core.convert.MatcherConverter;
import top.redscorpion.core.reflect.AbstractTypeReference;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsType;

public class CollectionConverter
implements MatcherConverter,
Serializable {
    private static final long serialVersionUID = 1L;
    public static CollectionConverter INSTANCE = new CollectionConverter();

    @Override
    public boolean match(Type targetType, Class<?> rawType, Object value) {
        return Collection.class.isAssignableFrom(rawType);
    }

    @Override
    public Collection<?> convert(Type targetType, Object value) {
        if (targetType instanceof AbstractTypeReference) {
            targetType = ((AbstractTypeReference)targetType).getType();
        }
        return this.convert(targetType, RsType.getTypeArgument(targetType), value);
    }

    public Collection<?> convert(Type collectionType, Type elementType, Object value) {
        Collection<?> collection = RsColl.create(RsType.getClass(collectionType), RsType.getClass(elementType));
        return RsColl.addAll(collection, value, elementType);
    }
}

