/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;
import top.redscorpion.core.convert.AbstractConverterWithRoot;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.convert.Converter;
import top.redscorpion.core.convert.MatcherConverter;
import top.redscorpion.core.convert.impl.ArrayConverter;
import top.redscorpion.core.convert.impl.CastConverter;
import top.redscorpion.core.convert.impl.ClassConverter;
import top.redscorpion.core.convert.impl.CollectionConverter;
import top.redscorpion.core.convert.impl.DateConverter;
import top.redscorpion.core.convert.impl.EmptyBeanConverter;
import top.redscorpion.core.convert.impl.EntryConverter;
import top.redscorpion.core.convert.impl.EnumConverter;
import top.redscorpion.core.convert.impl.KBeanConverter;
import top.redscorpion.core.convert.impl.MapConverter;
import top.redscorpion.core.convert.impl.NumberConverter;
import top.redscorpion.core.convert.impl.PrimitiveConverter;
import top.redscorpion.core.convert.impl.RecordConverter;
import top.redscorpion.core.convert.impl.TimeZoneConverter;
import top.redscorpion.core.convert.impl.ZoneIdConverter;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsStream;
import top.redscorpion.core.util.RsType;

public class SpecialConverter
extends AbstractConverterWithRoot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<MatcherConverter> converterSet;

    public SpecialConverter(Converter rootConverter) {
        super(rootConverter);
        this.converterSet = SpecialConverter.initDefault(Assert.notNull(rootConverter));
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        return this.convert(targetType, RsType.getClass(targetType), value);
    }

    public Object convert(Type targetType, Class<?> rawType, Object value) throws ConvertException {
        Converter converter = this.getConverter(targetType, rawType, value);
        return null == converter ? null : converter.convert(targetType, value);
    }

    public Converter getConverter(Type type, Class<?> rawType, Object value) {
        return SpecialConverter.getConverterFromSet(this.converterSet, type, rawType, value);
    }

    private static Converter getConverterFromSet(Set<? extends MatcherConverter> converterSet, Type type, Class<?> rawType, Object value) {
        return RsStream.of(converterSet).filter(predicate -> predicate.match(type, rawType, value)).findFirst().orElse(null);
    }

    private static Set<MatcherConverter> initDefault(Converter rootConverter) {
        LinkedHashSet<MatcherConverter> converterSet = new LinkedHashSet<MatcherConverter>(64);
        converterSet.add(CollectionConverter.INSTANCE);
        converterSet.add(new MapConverter(rootConverter));
        converterSet.add(new EntryConverter(rootConverter));
        converterSet.add(CastConverter.INSTANCE);
        converterSet.add(DateConverter.INSTANCE);
        converterSet.add(PrimitiveConverter.INSTANCE);
        converterSet.add(NumberConverter.INSTANCE);
        converterSet.add(EnumConverter.INSTANCE);
        converterSet.add(ArrayConverter.INSTANCE);
        converterSet.add(RecordConverter.INSTANCE);
        converterSet.add(KBeanConverter.INSTANCE);
        converterSet.add(ClassConverter.INSTANCE);
        converterSet.add(EmptyBeanConverter.INSTANCE);
        converterSet.add(TimeZoneConverter.INSTANCE);
        converterSet.add(ZoneIdConverter.INSTANCE);
        return converterSet;
    }
}

