/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Optional;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.convert.Converter;
import top.redscorpion.core.convert.MatcherConverter;
import top.redscorpion.core.convert.RegisterConverter;
import top.redscorpion.core.convert.SpecialConverter;
import top.redscorpion.core.convert.impl.BeanConverter;
import top.redscorpion.core.lang.Opt;
import top.redscorpion.core.reflect.AbstractTypeReference;
import top.redscorpion.core.util.RsBean;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsType;

public class CompositeConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;
    private RegisterConverter registerConverter;
    private SpecialConverter specialConverter;

    public static CompositeConverter getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private CompositeConverter() {
    }

    public CompositeConverter register(MatcherConverter converter) {
        this.registerConverter.register(converter);
        return this;
    }

    public CompositeConverter register(Type type, Converter converter) {
        this.registerConverter.register(type, converter);
        return this;
    }

    @Override
    public Object convert(Type type, Object value) throws ConvertException {
        return this.convert(type, value, null);
    }

    @Override
    public <T> T convert(Type type, Object value, T defaultValue) throws ConvertException {
        return this.convert(type, value, defaultValue, true);
    }

    public <T> T convert(Type type, Object value, T defaultValue, boolean isCustomFirst) throws ConvertException {
        Object result;
        Converter converter;
        if (RsObject.isNull(value)) {
            return defaultValue;
        }
        if (RsType.isUnknown(type)) {
            if (null == defaultValue) {
                return (T)value;
            }
            type = defaultValue.getClass();
        }
        if (value instanceof Opt && RsObject.isNull(value = ((Opt)value).getOrNull())) {
            return defaultValue;
        }
        if (value instanceof Optional && RsObject.isNull(value = ((Optional)value).orElse(null))) {
            return defaultValue;
        }
        if (value instanceof Converter) {
            return ((Converter)value).convert(type, value, defaultValue);
        }
        if (type instanceof AbstractTypeReference) {
            type = ((AbstractTypeReference)type).getType();
        }
        if (null != (converter = this.registerConverter.getConverter(type, value, isCustomFirst))) {
            return converter.convert(type, value, defaultValue);
        }
        Class<?> rawType = RsType.getClass(type);
        if (null == rawType) {
            if (null != defaultValue) {
                rawType = defaultValue.getClass();
            } else {
                throw new ConvertException("Can not get class from type: {}", type);
            }
        }
        if (null != (result = this.specialConverter.convert(type, rawType, value))) {
            return (T)result;
        }
        if (RsBean.isWritableBean(rawType)) {
            return (T)BeanConverter.INSTANCE.convert(type, value);
        }
        throw new ConvertException("Can not support from {}: [{}] to [{}]", value.getClass().getName(), value, type.getTypeName());
    }

    private static class SingletonHolder {
        private static final CompositeConverter INSTANCE = new CompositeConverter();

        private SingletonHolder() {
        }

        static {
            INSTANCE.registerConverter = new RegisterConverter(SingletonHolder.INSTANCE);
            INSTANCE.specialConverter = new SpecialConverter(SingletonHolder.INSTANCE);
        }
    }
}

