/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.collection;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsIter;
import top.redscorpion.core.util.RsSpliterator;

public class TransCollection<F, T>
extends AbstractCollection<T> {
    private final Collection<F> fromCollection;
    private final Function<? super F, ? extends T> function;

    public TransCollection(Collection<F> fromCollection, Function<? super F, ? extends T> function) {
        this.fromCollection = Assert.notNull(fromCollection);
        this.function = Assert.notNull(function);
    }

    @Override
    public Iterator<T> iterator() {
        return RsIter.trans(this.fromCollection.iterator(), this.function);
    }

    @Override
    public void clear() {
        this.fromCollection.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.fromCollection.isEmpty();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        Assert.notNull(action);
        this.fromCollection.forEach(f -> action.accept((T)this.function.apply(f)));
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        Assert.notNull(filter);
        return this.fromCollection.removeIf((? super E element) -> filter.test((T)this.function.apply(element)));
    }

    @Override
    public Spliterator<T> spliterator() {
        return RsSpliterator.trans(this.fromCollection.spliterator(), this.function);
    }

    @Override
    public int size() {
        return this.fromCollection.size();
    }
}

