/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.bean.path.node;

import java.util.List;
import top.redscorpion.core.bean.path.node.Node;
import top.redscorpion.core.util.RsSplit;
import top.redscorpion.core.util.RsString;

public class RangeNode
implements Node {
    private final int start;
    private final int end;
    private final int step;

    public RangeNode(String expression) {
        List<String> parts = RsSplit.splitTrim(expression, ":");
        this.start = Integer.parseInt(parts.get(0));
        this.end = Integer.parseInt(parts.get(1));
        int step = 1;
        if (3 == parts.size()) {
            step = Integer.parseInt(parts.get(2));
        }
        this.step = step;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getStep() {
        return this.step;
    }

    public String toString() {
        return RsString.format("[{}:{}:{}]", this.start, this.end, this.step);
    }
}

