/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.bean.copier;

import java.lang.reflect.Type;
import java.util.Map;
import top.redscorpion.core.bean.BeanException;
import top.redscorpion.core.bean.PropDesc;
import top.redscorpion.core.bean.copier.AbstractCopier;
import top.redscorpion.core.bean.copier.CopyOptions;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.mutable.MutableEntry;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsType;

public class BeanToBeanCopier<S, T>
extends AbstractCopier<S, T> {
    private final Type targetType;

    public BeanToBeanCopier(S source, T target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        this.targetType = targetType;
    }

    @Override
    public T copy() {
        Map<String, PropDesc> targetPropDescMap;
        CopyOptions copyOptions = this.copyOptions;
        Class<?> actualEditable = this.target.getClass();
        if (null != copyOptions.editable) {
            Assert.isTrue(copyOptions.editable.isInstance(this.target), "Target class [{}] not assignable to Editable class [{}]", actualEditable.getName(), copyOptions.editable.getName());
            actualEditable = copyOptions.editable;
        }
        if (RsMap.isEmpty(targetPropDescMap = this.getBeanDesc(actualEditable).getPropMap(copyOptions.ignoreCase))) {
            if (copyOptions.ignoreError) {
                return (T)this.target;
            }
            throw new BeanException("No properties for target: {}", actualEditable);
        }
        Map<String, PropDesc> sourcePropDescMap = this.getBeanDesc(this.source.getClass()).getPropMap(copyOptions.ignoreCase);
        if (RsMap.isEmpty(sourcePropDescMap)) {
            if (copyOptions.ignoreError) {
                return (T)this.target;
            }
            throw new BeanException("No properties for source: {}", this.source.getClass());
        }
        sourcePropDescMap.forEach((sFieldName, sDesc) -> {
            if (null == sFieldName || !sDesc.isReadable(copyOptions.transientSupport)) {
                return;
            }
            Object sValue = sDesc.getValue(this.source, copyOptions.ignoreError);
            if (!this.copyOptions.testPropertyFilter(sDesc.getField(), sValue)) {
                return;
            }
            MutableEntry<Object, Object> entry = copyOptions.editField(sFieldName, sValue);
            if (null == entry) {
                return;
            }
            sFieldName = RsString.toStringOrNull(entry.getKey());
            if (null == sFieldName) {
                return;
            }
            sValue = entry.getValue();
            PropDesc tDesc = copyOptions.findPropDesc(targetPropDescMap, (String)sFieldName);
            if (null == tDesc || !tDesc.isWritable(copyOptions.transientSupport)) {
                return;
            }
            Type fieldType = RsType.getActualType(this.targetType, tDesc.getFieldType());
            sValue = copyOptions.convertField(fieldType, sValue);
            tDesc.setValue(this.target, sValue, copyOptions.ignoreNullValue, copyOptions.ignoreError, copyOptions.override);
        });
        return (T)this.target;
    }
}

