/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.template.engine.velocity;

import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;
import top.redscorpion.template.Template;
import top.redscorpion.template.TemplateConfig;
import top.redscorpion.template.engine.TemplateEngine;
import top.redscorpion.template.engine.velocity.SimpleStringResourceLoader;
import top.redscorpion.template.engine.velocity.VelocityTemplate;

public class VelocityEngine
implements TemplateEngine {
    private org.apache.velocity.app.VelocityEngine engine;
    private TemplateConfig config;

    public VelocityEngine() {
        Assert.notNull(org.apache.velocity.app.VelocityEngine.class);
    }

    public VelocityEngine(TemplateConfig config) {
        this.init(config);
    }

    public VelocityEngine(org.apache.velocity.app.VelocityEngine engine) {
        this.init(engine);
    }

    @Override
    public TemplateEngine init(TemplateConfig config) {
        if (null == config) {
            config = TemplateConfig.DEFAULT;
        }
        this.config = config;
        this.init(VelocityEngine.createEngine(config));
        return this;
    }

    private void init(org.apache.velocity.app.VelocityEngine engine) {
        this.engine = engine;
    }

    @Override
    public org.apache.velocity.app.VelocityEngine getRaw() {
        return this.engine;
    }

    @Override
    public Template getTemplate(String resource) {
        if (null == this.engine) {
            this.init(TemplateConfig.DEFAULT);
        }
        String charsetStr = null;
        if (null != this.config) {
            String root = this.config.getPath();
            charsetStr = this.config.getCharsetStr();
            TemplateConfig.ResourceMode resourceMode = this.config.getResourceMode();
            if (TemplateConfig.ResourceMode.CLASSPATH == resourceMode || TemplateConfig.ResourceMode.WEB_ROOT == resourceMode) {
                resource = RsString.addPrefixIfNot(resource, RsString.addSuffixIfNot(root, "/"));
            }
        }
        return VelocityTemplate.wrap(this.engine.getTemplate(resource, charsetStr));
    }

    private static org.apache.velocity.app.VelocityEngine createEngine(TemplateConfig config) {
        if (null == config) {
            config = new TemplateConfig();
        }
        org.apache.velocity.app.VelocityEngine ve = new org.apache.velocity.app.VelocityEngine();
        String charsetStr = config.getCharset().toString();
        ve.setProperty("resource.default_encoding", (Object)charsetStr);
        ve.setProperty("resource.loader.file.cache", (Object)true);
        switch (config.getResourceMode()) {
            case CLASSPATH: {
                ve.setProperty("resource.loader.file.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
                break;
            }
            case FILE: {
                String path = config.getPath();
                if (null == path) break;
                ve.setProperty("resource.loader.file.path", (Object)path);
                break;
            }
            case WEB_ROOT: {
                ve.setProperty("resource.loaders", (Object)"webapp");
                ve.setProperty("webapp.resource.loader.class", (Object)"org.apache.velocity.tools.view.servlet.WebappLoader");
                ve.setProperty("webapp.resource.loader.path", (Object)RsObject.defaultIfNull(config.getPath(), "/"));
                break;
            }
            case STRING: {
                ve.setProperty("resource.loaders", (Object)"str");
                ve.setProperty("resource.loader.str.class", (Object)SimpleStringResourceLoader.class.getName());
                break;
            }
        }
        ve.init();
        return ve;
    }
}

