/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.shape;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsFileType;
import top.redscorpion.core.util.RsList;
import top.redscorpion.core.util.RsStream;
import top.redscorpion.core.util.RsString;
import top.redscorpion.poi.excel.shape.ExcelPicType;

public class RsExcelPic {
    public static ExcelPicType getPicType(File picFile) {
        String type = RsFileType.getType(picFile);
        if (RsString.equalsAnyIgnoreCase(type, "jpg", "jpeg")) {
            return ExcelPicType.JPEG;
        }
        if (RsString.equalsAnyIgnoreCase(type, "emf")) {
            return ExcelPicType.EMF;
        }
        if (RsString.equalsAnyIgnoreCase(type, "wmf")) {
            return ExcelPicType.WMF;
        }
        if (RsString.equalsAnyIgnoreCase(type, "pict")) {
            return ExcelPicType.PICT;
        }
        if (RsString.equalsAnyIgnoreCase(type, "dib")) {
            return ExcelPicType.DIB;
        }
        return ExcelPicType.PNG;
    }

    public static void writePicTo(Picture pic, File file) {
        RsExcelPic.writePicTo(pic.getPictureData(), file);
    }

    public static void writePicTo(PictureData pic, File file) {
        RsFile.writeBytes(pic.getData(), file);
    }

    public static List<? extends PictureData> getAllPictures(Workbook workbook) {
        return workbook.getAllPictures();
    }

    public static List<Picture> getShapePics(Workbook workbook, int sheetIndex) {
        Assert.notNull(workbook, "Workbook must be not null !", new Object[0]);
        if (sheetIndex < 0) {
            sheetIndex = 0;
        }
        return RsExcelPic.getShapePics(workbook.getSheetAt(sheetIndex));
    }

    public static List<Picture> getShapePics(Sheet sheet) {
        Assert.notNull(sheet, "Sheet must be not null !", new Object[0]);
        Drawing drawing = sheet.getDrawingPatriarch();
        if (null == drawing) {
            return RsList.empty();
        }
        return RsStream.of(drawing).filter(shape -> shape instanceof Picture).map(shape -> (Picture)shape).collect(Collectors.toList());
    }
}

