/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.sax;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import top.redscorpion.core.date.DateTime;
import top.redscorpion.core.exception.DependencyException;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.util.RsDate;
import top.redscorpion.core.util.RsNumber;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;
import top.redscorpion.poi.POIException;
import top.redscorpion.poi.excel.RsExcelDate;
import top.redscorpion.poi.excel.sax.CellDataType;
import top.redscorpion.poi.excel.sax.Excel03SaxReader;
import top.redscorpion.poi.excel.sax.Excel07SaxReader;
import top.redscorpion.poi.excel.sax.ExcelSaxReader;
import top.redscorpion.poi.excel.sax.StopReadException;
import top.redscorpion.poi.excel.sax.handler.RowHandler;

public class RsExcelSax {
    public static final char CELL_FILL_CHAR = '@';
    public static final int MAX_CELL_BIT = 3;

    public static ExcelSaxReader<?> createSaxReader(boolean isXlsx, RowHandler rowHandler) {
        return isXlsx ? new Excel07SaxReader(rowHandler) : new Excel03SaxReader(rowHandler);
    }

    public static Object getDataValue(CellDataType cellDataType, String value, SharedStrings sharedStrings, String numFmtString) {
        if (null == value) {
            return null;
        }
        if (null == cellDataType) {
            cellDataType = CellDataType.NULL;
        }
        Object result = null;
        switch (cellDataType) {
            case BOOL: {
                result = value.charAt(0) != '0';
                break;
            }
            case ERROR: {
                result = RsString.format("\\\"ERROR: {} ", value);
                break;
            }
            case FORMULA: {
                result = RsString.format("\"{}\"", value);
                break;
            }
            case INLINESTR: {
                result = new XSSFRichTextString(value).toString();
                break;
            }
            case SSTINDEX: {
                try {
                    int index = Integer.parseInt(value);
                    result = sharedStrings.getItemAt(index).getString();
                }
                catch (NumberFormatException e) {
                    result = value;
                }
                break;
            }
            case DATE: {
                try {
                    result = RsExcelSax.getDateValue(value);
                }
                catch (Exception e) {
                    result = value;
                }
                break;
            }
            default: {
                try {
                    result = RsExcelSax.getNumberValue(value, numFmtString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (null != result) break;
                result = value;
            }
        }
        return result;
    }

    public static String formatCellContent(String value, int numFmtIndex, String numFmtString) {
        if (null != numFmtString) {
            try {
                value = new DataFormatter().formatRawCellContents(Double.parseDouble(value), numFmtIndex, numFmtString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public static int countNullCell(String preRef, String ref) {
        String preXfd = RsObject.defaultIfNull(preRef, "@").replaceAll("\\d+", "");
        String xfd = RsObject.defaultIfNull(ref, "@").replaceAll("\\d+", "");
        preXfd = RsString.fillBefore(preXfd, '@', 3);
        xfd = RsString.fillBefore(xfd, '@', 3);
        char[] preLetter = preXfd.toCharArray();
        char[] letter = xfd.toCharArray();
        int res = (letter[0] - preLetter[0]) * 26 * 26 + (letter[1] - preLetter[1]) * 26 + (letter[2] - preLetter[2]);
        return res - 1;
    }

    public static void readFrom(InputStream xmlDocStream, ContentHandler handler) throws DependencyException, POIException, IORuntimeException {
        XMLReader xmlReader;
        try {
            xmlReader = XMLHelper.newXMLReader();
        }
        catch (ParserConfigurationException | SAXException e) {
            if (e.getMessage().contains("org.apache.xerces.parsers.SAXParser")) {
                throw new DependencyException(e, "You need to add 'xerces:xercesImpl' to your project and version >= 2.11.0", new Object[0]);
            }
            throw new POIException(e);
        }
        xmlReader.setContentHandler(handler);
        try {
            xmlReader.parse(new InputSource(xmlDocStream));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (SAXException e) {
            throw new POIException(e);
        }
        catch (StopReadException stopReadException) {
            // empty catch block
        }
    }

    public static boolean isDateFormat(CellValueRecordInterface cell, FormatTrackingHSSFListener formatListener) {
        int formatIndex = formatListener.getFormatIndex(cell);
        String formatString = formatListener.getFormatString(cell);
        return RsExcelSax.isDateFormat(formatIndex, formatString);
    }

    public static boolean isDateFormat(int formatIndex, String formatString) {
        return RsExcelDate.isDateFormat(formatIndex, formatString);
    }

    public static DateTime getDateValue(String value) {
        return RsExcelSax.getDateValue(Double.parseDouble(value));
    }

    public static DateTime getDateValue(double value) {
        return RsDate.date(DateUtil.getJavaDate((double)value, (boolean)false));
    }

    public static Object getNumberOrDateValue(CellValueRecordInterface cell, double value, FormatTrackingHSSFListener formatListener) {
        if (RsExcelSax.isDateFormat(cell, formatListener)) {
            return RsExcelSax.getDateValue(value);
        }
        return RsExcelSax.getNumberValue(value, formatListener.getFormatString(cell));
    }

    private static Number getNumberValue(String value, String numFmtString) {
        if (RsString.isBlank(value)) {
            return null;
        }
        double number = Double.parseDouble(value);
        if (RsString.contains((CharSequence)value, '.') && !value.equals(Double.toString(number))) {
            return RsNumber.toBigDecimal(value);
        }
        return RsExcelSax.getNumberValue(number, numFmtString);
    }

    private static Number getNumberValue(double numValue, String numFmtString) {
        long longPart;
        if (null != numFmtString && !RsString.contains((CharSequence)numFmtString, '.') && (double)(longPart = (long)numValue) == numValue) {
            return longPart;
        }
        return numValue;
    }
}

