/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.jdk;

import java.net.Proxy;
import java.net.URL;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsUrl;
import top.redscorpion.http.client.ClientConfig;
import top.redscorpion.http.client.Request;
import top.redscorpion.http.client.engine.EngineRequestBuilder;
import top.redscorpion.http.client.engine.jdk.JdkCookieManager;
import top.redscorpion.http.client.engine.jdk.JdkHttpConnection;
import top.redscorpion.http.meta.HeaderName;
import top.redscorpion.http.proxy.ProxyInfo;

public class JdkRequestBuilder
implements EngineRequestBuilder<JdkHttpConnection> {
    private final ClientConfig config;
    private final JdkCookieManager cookieManager;

    public JdkRequestBuilder(ClientConfig config, JdkCookieManager cookieManager) {
        this.config = RsObject.defaultIfNull(config, ClientConfig::of);
        this.cookieManager = cookieManager;
    }

    @Override
    public JdkHttpConnection build(Request message) {
        ClientConfig config = this.config;
        URL url = message.handledUrl().toUrl();
        Proxy proxy = null;
        ProxyInfo proxyInfo = config.getProxy();
        if (null != proxyInfo) {
            proxy = proxyInfo.selectFirst(RsUrl.toUri(url));
        }
        JdkHttpConnection conn = (JdkHttpConnection)JdkHttpConnection.of(url, proxy).setConnectTimeout(config.getConnectionTimeout()).setReadTimeout(config.getReadTimeout()).setMethod(message.method()).setSslInfo(config.getSslInfo()).setInstanceFollowRedirects(false).setDisableCache(config.isDisableCache()).header(message.headers(), true);
        if (!message.method().isIgnoreBody()) {
            long contentLength = message.contentLength();
            if (contentLength > 0L) {
                conn.setFixedLengthStreamingMode(contentLength);
            } else if (message.isChunked()) {
                conn.setChunkedStreamingMode(4096);
            }
        }
        if (null == message.header(HeaderName.COOKIE) && null != this.cookieManager) {
            conn.header(this.cookieManager.loadForRequest(conn), false);
        }
        return conn;
    }
}

