/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.jdk;

import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsUrl;
import top.redscorpion.http.client.cookie.CookieStoreSpi;
import top.redscorpion.http.client.engine.jdk.JdkCookieStore;
import top.redscorpion.http.client.engine.jdk.JdkHttpConnection;

public class JdkCookieManager {
    private CookieManager cookieManager;

    public JdkCookieManager(CookieStoreSpi cookieStore) {
        this(new CookieManager(new JdkCookieStore(cookieStore), CookiePolicy.ACCEPT_ALL));
    }

    public JdkCookieManager(CookieManager raw) {
        this.cookieManager = raw;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public JdkCookieManager setCookieManager(CookieManager cookieManager) {
        this.cookieManager = cookieManager;
        return this;
    }

    public List<HttpCookie> getCookies(JdkHttpConnection conn) {
        if (null == this.cookieManager) {
            return null;
        }
        return this.cookieManager.getCookieStore().get(JdkCookieManager.getURI(conn));
    }

    public Map<String, List<String>> loadForRequest(JdkHttpConnection conn) {
        if (null == this.cookieManager) {
            return null;
        }
        try {
            return this.cookieManager.get(JdkCookieManager.getURI(conn), new HashMap<String, List<String>>(0));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public JdkCookieManager saveFromResponse(JdkHttpConnection conn) {
        return this.saveFromResponse(conn, conn.headers());
    }

    public JdkCookieManager saveFromResponse(JdkHttpConnection conn, Map<String, List<String>> responseHeaders) {
        if (null == this.cookieManager || RsMap.isEmpty(responseHeaders)) {
            return this;
        }
        try {
            this.cookieManager.put(JdkCookieManager.getURI(conn), responseHeaders);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    private static URI getURI(JdkHttpConnection conn) {
        return RsUrl.toUri(conn.getUrl());
    }
}

