/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.httpclient4;

import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.net.url.UrlBuilder;
import top.redscorpion.http.client.Request;
import top.redscorpion.http.client.body.HttpBody;
import top.redscorpion.http.client.engine.EngineRequestBuilder;
import top.redscorpion.http.client.engine.httpclient4.HttpClient4BodyEntity;
import top.redscorpion.http.meta.HeaderName;

public class HttpUriRequestBuilder
implements EngineRequestBuilder<HttpUriRequest> {
    public static final HttpUriRequestBuilder INSTANCE = new HttpUriRequestBuilder();

    @Override
    public HttpUriRequest build(Request message) {
        UrlBuilder url = message.handledUrl();
        Assert.notNull(url, "Request URL must be not null!", new Object[0]);
        RequestBuilder requestBuilder = RequestBuilder.create((String)message.method().name()).setUri(url.toUri());
        requestBuilder.setConfig(HttpUriRequestBuilder.buildRequestConfig(message));
        message.headers().forEach((k, v1) -> v1.forEach(v2 -> requestBuilder.addHeader(k, v2)));
        HttpBody body = message.handledBody();
        if (null != body) {
            requestBuilder.setEntity((HttpEntity)new HttpClient4BodyEntity(message.header(HeaderName.CONTENT_TYPE), message.contentEncoding(), message.isChunked(), body));
        }
        return requestBuilder.build();
    }

    private static RequestConfig buildRequestConfig(Request request) {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        int maxRedirects = request.maxRedirects();
        if (maxRedirects > 0) {
            requestConfigBuilder.setMaxRedirects(maxRedirects);
        } else {
            requestConfigBuilder.setRedirectsEnabled(false);
        }
        return requestConfigBuilder.build();
    }
}

