/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine;

import top.redscorpion.core.lang.Singleton;
import top.redscorpion.core.spi.ServiceLoader;
import top.redscorpion.core.util.RsSpi;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.HttpException;
import top.redscorpion.http.client.ClientConfig;
import top.redscorpion.http.client.engine.ClientEngine;
import top.redscorpion.http.client.engine.ClientEngineName;
import top.redscorpion.log.RsLog;

public class ClientEngineFactory {
    public static ClientEngine getEngine() {
        return Singleton.get(ClientEngine.class.getName(), ClientEngineFactory::createEngine);
    }

    public static ClientEngine createEngine(ClientConfig config) {
        return ClientEngineFactory.createEngine().init(config);
    }

    public static ClientEngine createEngine(ClientEngineName engineName) throws HttpException {
        ServiceLoader<ClientEngine> list = RsSpi.loadList(ClientEngine.class);
        for (String serviceName : list.getServiceNames()) {
            if (!RsString.endWithIgnoreCase(serviceName, engineName.getValue())) continue;
            return list.getService(serviceName);
        }
        throw new HttpException("No such engine named: " + engineName.getValue());
    }

    public static ClientEngine createEngine() {
        ClientEngine engine = RsSpi.loadFirstAvailable(ClientEngine.class);
        RsLog.debug("Use [{}] Http Engine As Default.", RsString.removeSuffix(engine.getClass().getSimpleName(), "Engine"));
        return engine;
    }
}

