/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import top.redscorpion.core.map.CaseInsensitiveMap;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsUrlQuery;
import top.redscorpion.http.client.ClientConfig;
import top.redscorpion.http.client.Request;
import top.redscorpion.http.client.Response;
import top.redscorpion.http.client.engine.ClientEngine;
import top.redscorpion.http.client.engine.ClientEngineFactory;
import top.redscorpion.http.client.engine.ClientEngineName;
import top.redscorpion.http.meta.Method;

public class RsHttp {
    public static boolean isHttps(String url) {
        return RsString.startWithIgnoreCase(url, "https:");
    }

    public static boolean isHttp(String url) {
        return RsString.startWithIgnoreCase(url, "http:");
    }

    public static Request createRequest(String url, Method method) {
        return Request.of(url).method(method);
    }

    public static Request createGet(String url) {
        return RsHttp.createRequest(url, Method.GET);
    }

    public static Request createPost(String url) {
        return RsHttp.createRequest(url, Method.POST);
    }

    public static String get(String urlString, Charset customCharset) {
        return RsHttp.send(Request.of(urlString).charset(customCharset)).bodyStr();
    }

    public static String get(String urlString) {
        return ClientEngineFactory.getEngine().send(Request.of(urlString)).bodyStr();
    }

    public static String get(String urlString, int timeout) {
        return ClientEngineFactory.createEngine().init(ClientConfig.of().setConnectionTimeout(timeout).setReadTimeout(timeout)).send(Request.of(urlString)).bodyStr();
    }

    public static String get(String urlString, Map<String, Object> paramMap) {
        return RsHttp.send(Request.of(urlString).form(paramMap)).bodyStr();
    }

    public static String post(String urlString, Map<String, Object> paramMap) {
        return RsHttp.send(Request.of(urlString).method(Method.POST).form(paramMap)).bodyStr();
    }

    public static String post(String urlString, String body) {
        return RsHttp.send(Request.of(urlString).method(Method.POST).body(body)).bodyStr();
    }

    public static String post(String urlString, String body, int timeout) {
        return ClientEngineFactory.createEngine().init(ClientConfig.of().setConnectionTimeout(timeout).setReadTimeout(timeout)).send(Request.of(urlString).method(Method.POST).body(body)).bodyStr();
    }

    public static Response send(Request request) {
        return ClientEngineFactory.getEngine().send(request);
    }

    public static String urlWithFormUrlEncoded(String url, Map<String, Object> form, Charset charset) {
        return RsHttp.urlWithForm(url, form, charset, true);
    }

    public static String urlWithForm(String url, Map<String, Object> form, Charset charset, boolean isEncodeParams) {
        return RsHttp.urlWithForm(url, RsUrlQuery.toQuery(form, null), charset, isEncodeParams);
    }

    public static String urlWithForm(String url, String queryString, Charset charset, boolean isEncode) {
        if (RsString.isBlank(queryString)) {
            if (RsString.contains((CharSequence)url, '?')) {
                return isEncode ? RsUrlQuery.encodeQuery(url, charset) : url;
            }
            return url;
        }
        StringBuilder urlBuilder = new StringBuilder(url.length() + queryString.length() + 16);
        int qmIndex = url.indexOf(63);
        if (qmIndex > 0) {
            urlBuilder.append(isEncode ? RsUrlQuery.encodeQuery(url, charset) : url);
            if (!RsString.endWith((CharSequence)url, '&')) {
                urlBuilder.append('&');
            }
        } else {
            urlBuilder.append(url);
            if (qmIndex < 0) {
                urlBuilder.append('?');
            }
        }
        urlBuilder.append(isEncode ? RsUrlQuery.encodeQuery(queryString, charset) : queryString);
        return urlBuilder.toString();
    }

    public static ClientEngine createClient(ClientEngineName engineName) {
        return ClientEngineFactory.createEngine(engineName);
    }

    public static String toString(Response response) {
        StringBuilder sb = new StringBuilder();
        sb.append("Response Status: ").append(response.getStatus()).append("\r\n");
        sb.append("Response Headers: ").append("\r\n");
        response.headers().forEach((key, value) -> sb.append("    ").append((String)key).append(": ").append(RsColl.join(value, ",")).append("\r\n"));
        sb.append("Response Body: ").append("\r\n");
        sb.append("    ").append(response.bodyStr()).append("\r\n");
        return sb.toString();
    }

    public static String toString(Request request) {
        StringBuilder sb = new StringBuilder();
        sb.append("Request Url: ").append(request.url()).append("\r\n");
        sb.append("Request Headers: ").append("\r\n");
        request.headers().forEach((key, value) -> sb.append("    ").append((String)key).append(": ").append(RsColl.join(value, ",")).append("\r\n"));
        sb.append("Request Body: ").append("\r\n");
        sb.append("    ").append(request.bodyStr()).append("\r\n");
        return sb.toString();
    }

    public static String header(Map<String, ? extends Collection<String>> headers, String name) {
        Collection<String> values = headers.get(name);
        if (null == values && !(headers instanceof CaseInsensitiveMap)) {
            values = RsMap.firstMatchValue(headers, entry -> RsString.equalsIgnoreCase(name, (CharSequence)entry.getKey()));
        }
        if (RsColl.isNotEmpty(values)) {
            return RsColl.getFirst(values);
        }
        return null;
    }

    public static String get(Request request) {
        return RsHttp.send(request).bodyStr();
    }

    public static String post(String urlString) {
        return RsHttp.send(Request.of(urlString).method(Method.POST)).bodyStr();
    }

    public static String post(Request request) {
        return RsHttp.send(request.method(Method.POST)).bodyStr();
    }
}

