/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.redscorpion.core.convert.CompositeConverter;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.convert.impl.CollectionConverter;
import top.redscorpion.core.convert.impl.MapConverter;
import top.redscorpion.core.reflect.AbstractTypeReference;

public class RsConvert {
    public static String toStr(Object value, String defaultValue) {
        return RsConvert.convertQuietly(String.class, value, defaultValue);
    }

    public static String toStr(Object value) {
        return RsConvert.toStr(value, null);
    }

    public static Integer toInt(Object value, Integer defaultValue) {
        return RsConvert.convertQuietly(Integer.class, value, defaultValue);
    }

    public static Integer toInt(Object value) {
        return RsConvert.toInt(value, null);
    }

    public static Long toLong(Object value, Long defaultValue) {
        return RsConvert.convertQuietly(Long.class, value, defaultValue);
    }

    public static Collection<?> toCollection(Class<?> collectionType, Class<?> elementType, Object value) {
        return new CollectionConverter().convert(collectionType, elementType, value);
    }

    public static <T> List<T> toList(Class<T> elementType, Object value) {
        return (List)RsConvert.toCollection(ArrayList.class, elementType, value);
    }

    public static <K, V> Map<K, V> toMap(Class<K> keyType, Class<V> valueType, Object value) {
        if (value instanceof Map) {
            return RsConvert.toMap(value.getClass(), keyType, valueType, value);
        }
        return RsConvert.toMap(HashMap.class, keyType, valueType, value);
    }

    public static <K, V> Map<K, V> toMap(Class<?> mapType, Class<K> keyType, Class<V> valueType, Object value) {
        return MapConverter.INSTANCE.convert(mapType, keyType, valueType, value);
    }

    public static <T> T convert(Class<T> type, Object value) throws ConvertException {
        return RsConvert.convert(type, value);
    }

    public static <T> T convert(AbstractTypeReference<T> reference, Object value) throws ConvertException {
        return RsConvert.convert(reference.getType(), value, null);
    }

    public static <T> T convert(Type type, Object value) throws ConvertException {
        return RsConvert.convert(type, value, null);
    }

    public static <T> T convert(Class<T> type, Object value, T defaultValue) throws ConvertException {
        return RsConvert.convert(type, value, defaultValue);
    }

    public static <T> T convert(Type type, Object value, T defaultValue) throws ConvertException {
        return RsConvert.convertWithCheck(type, value, defaultValue, false);
    }

    public static <T> T convertQuietly(Type type, Object value, T defaultValue) {
        return RsConvert.convertWithCheck(type, value, defaultValue, true);
    }

    public static <T> T convertWithCheck(Type type, Object value, T defaultValue, boolean quietly) {
        CompositeConverter compositeConverter = CompositeConverter.getInstance();
        try {
            return compositeConverter.convert(type, value, defaultValue);
        }
        catch (Exception e) {
            if (quietly) {
                return defaultValue;
            }
            throw e;
        }
    }
}

