/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.net.url;

import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.net.url.RFC3986;
import top.redscorpion.core.net.url.UrlDecoder;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsSplit;
import top.redscorpion.core.util.RsString;

public class UrlPath {
    private List<CharSequence> segments;
    private boolean withEngTag;

    public static UrlPath of() {
        return new UrlPath();
    }

    public static UrlPath of(CharSequence pathStr, Charset charset) {
        return UrlPath.of().parse(pathStr, charset);
    }

    public UrlPath parse(CharSequence path, Charset charset) {
        if (RsString.isNotEmpty(path)) {
            if (RsString.endWith(path, '/')) {
                this.withEngTag = true;
            }
            if (RsString.isNotEmpty(path = UrlPath.fixPath(path))) {
                List<String> split = RsSplit.split(path, "/");
                for (String seg : split) {
                    this.addInternal(UrlDecoder.decodeForPath(seg, charset), false);
                }
            }
        }
        return this;
    }

    public String build(Charset charset) {
        if (RsColl.isEmpty(this.segments)) {
            return this.withEngTag ? "/" : "";
        }
        StringBuilder builder = new StringBuilder();
        for (CharSequence segment : this.segments) {
            builder.append('/').append(RFC3986.SEGMENT.encode(segment, charset, new char[0]));
        }
        if (this.withEngTag) {
            if (RsString.isEmpty(builder)) {
                builder.append('/');
            } else if (!RsString.endWith((CharSequence)builder, '/')) {
                builder.append('/');
            }
        }
        return builder.toString();
    }

    public String toString() {
        return this.build(null);
    }

    private void addInternal(CharSequence segment, boolean before) {
        if (this.segments == null) {
            this.segments = new LinkedList<CharSequence>();
        }
        if (before) {
            this.segments.add(0, segment);
        } else {
            this.segments.add(segment);
        }
    }

    private static String fixPath(CharSequence path) {
        Assert.notNull(path, "Path segment must be not null!", new Object[0]);
        if ("/".contentEquals(path)) {
            return "";
        }
        String segmentStr = RsString.trim(path);
        segmentStr = RsString.removePrefix(segmentStr, "/");
        segmentStr = RsString.removeSuffix(segmentStr, "/");
        segmentStr = RsString.trim(segmentStr);
        return segmentStr;
    }
}

