/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.map;

import java.util.LinkedHashMap;
import top.redscorpion.core.exception.CloneException;
import top.redscorpion.core.lang.getter.TypeGetter;
import top.redscorpion.core.map.AbstractCustomKeyMap;

public class Dict
extends AbstractCustomKeyMap<String, Object>
implements TypeGetter<String> {
    private static final long serialVersionUID = 6135423866861206530L;
    protected boolean caseInsensitive;

    public Dict() {
        this(false);
    }

    public Dict(boolean caseInsensitive) {
        this(16, caseInsensitive);
    }

    public Dict(int initialCapacity, boolean caseInsensitive) {
        this(initialCapacity, 0.75f, caseInsensitive);
    }

    public Dict(int initialCapacity, float loadFactor, boolean caseInsensitive) {
        super(new LinkedHashMap(initialCapacity, loadFactor));
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public Object getObj(String key, Object defaultValue) {
        return this.getOrDefault(key, defaultValue);
    }

    @Override
    public Dict clone() {
        try {
            return (Dict)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CloneException(e);
        }
    }

    @Override
    protected String customKey(Object key) {
        if (this.caseInsensitive && null != key) {
            key = ((String)key).toLowerCase();
        }
        return (String)key;
    }
}

