/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.lang;

import java.util.function.Supplier;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;

public class Assert {
    private static final String TEMPLATE_VALUE_MUST_BE_BETWEEN_AND = "The value must be between {} and {}.";

    public static <X extends Throwable> void isTrue(boolean expression, Supplier<? extends X> supplier) throws X {
        if (!expression) {
            throw (Throwable)supplier.get();
        }
    }

    public static void isTrue(boolean expression, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        Assert.isTrue(expression, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static void isTrue(boolean expression) throws IllegalArgumentException {
        Assert.isTrue(expression, "[Assertion failed] - this expression must be true", new Object[0]);
    }

    public static <X extends Throwable> void isFalse(boolean expression, Supplier<X> errorSupplier) throws X {
        if (expression) {
            throw (Throwable)errorSupplier.get();
        }
    }

    public static void isFalse(boolean expression, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        Assert.isFalse(expression, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static <T, X extends Throwable> T notNull(T object, Supplier<X> errorSupplier) throws X {
        if (null == object) {
            throw (Throwable)errorSupplier.get();
        }
        return object;
    }

    public static <T> T notNull(T object, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (null == object) {
            throw new IllegalArgumentException(RsString.format(errorMsgTemplate, params));
        }
        return object;
    }

    public static <T> T notNull(T object) throws IllegalArgumentException {
        if (null == object) {
            throw new IllegalArgumentException("[Assertion failed] - this argument is required; it must not be null");
        }
        return object;
    }

    public static <T extends CharSequence, X extends Throwable> T notEmpty(T text, Supplier<X> errorSupplier) throws X {
        if (RsString.isEmpty(text)) {
            throw (Throwable)errorSupplier.get();
        }
        return text;
    }

    public static <T extends CharSequence> T notEmpty(T text, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        return Assert.notEmpty(text, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static <T extends CharSequence> T notEmpty(T text) throws IllegalArgumentException {
        return Assert.notEmpty(text, "[Assertion failed] - this String argument must have length; it must not be null or empty", new Object[0]);
    }

    public static <T extends CharSequence, X extends Throwable> T notBlank(T text, Supplier<X> errorMsgSupplier) throws X {
        if (RsString.isBlank(text)) {
            throw (Throwable)errorMsgSupplier.get();
        }
        return text;
    }

    public static <T extends CharSequence> T notBlank(T text, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        return Assert.notBlank(text, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static <T extends CharSequence> T notBlank(T text) throws IllegalArgumentException {
        return Assert.notBlank(text, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank", new Object[0]);
    }

    public static <T> T isInstanceOf(Class<?> type, T obj, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        Assert.notNull(type, "Type to check against must not be null", new Object[0]);
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException(RsString.format(errorMsgTemplate, params));
        }
        return obj;
    }

    public static <T> T isNotInstanceOf(Class<?> type, T obj) {
        return Assert.isNotInstanceOf(type, obj, "Object [{}] must be not instanceof [{}]", obj, type);
    }

    public static <T> T isNotInstanceOf(Class<?> type, T obj, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        Assert.notNull(type, "Type to check against must not be null", new Object[0]);
        if (type.isInstance(obj)) {
            throw new IllegalArgumentException(RsString.format(errorMsgTemplate, params));
        }
        return obj;
    }

    public static <X extends Throwable> long checkBetween(long value, long min, long max, Supplier<? extends X> errorSupplier) throws X {
        if (value < min || value > max) {
            throw (Throwable)errorSupplier.get();
        }
        return value;
    }

    public static long checkBetween(long value, long min, long max, String errorMsgTemplate, Object ... params) {
        return Assert.checkBetween(value, min, max, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static long checkBetween(long value, long min, long max) {
        return Assert.checkBetween(value, min, max, TEMPLATE_VALUE_MUST_BE_BETWEEN_AND, min, max);
    }

    public static void equals(Object obj1, Object obj2, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        Assert.equals(obj1, obj2, () -> new IllegalArgumentException(RsString.format(errorMsgTemplate, params)));
    }

    public static <X extends Throwable> void equals(Object obj1, Object obj2, Supplier<X> errorSupplier) throws X {
        if (RsObject.notEquals(obj1, obj2)) {
            throw (Throwable)errorSupplier.get();
        }
    }
}

