/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io.file;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.file.visitor.MoveVisitor;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsPath;
import top.redscorpion.core.util.RsString;

public class PathMover {
    private final Path src;
    private final Path target;
    private final CopyOption[] options;

    public static PathMover of(Path src, Path target, boolean isOverride) {
        CopyOption[] copyOptionArray;
        if (isOverride) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        return PathMover.of(src, target, copyOptionArray);
    }

    public static PathMover of(Path src, Path target, CopyOption[] options) {
        return new PathMover(src, target, options);
    }

    public PathMover(Path src, Path target, CopyOption[] options) {
        Assert.notNull(target, "Src path must be not null !", new Object[0]);
        if (!RsPath.exists(src, false)) {
            throw new IllegalArgumentException("Src path is not exist!");
        }
        this.src = src;
        this.target = Assert.notNull(target, "Target path must be not null !", new Object[0]);
        this.options = RsObject.defaultIfNull(options, () -> new CopyOption[0]);
    }

    public Path move() throws IllegalArgumentException {
        Path src = this.src;
        Path target = this.target;
        CopyOption[] options = this.options;
        if (RsPath.isSub(src, target)) {
            if (RsPath.equals(src, target)) {
                return target;
            }
            throw new IllegalArgumentException(RsString.format("Target [{}] is sub path of src [{}]!", target, src));
        }
        if (RsPath.isDirectory(target)) {
            target = target.resolve(src.getFileName());
        }
        RsPath.mkParentDirs(target);
        try {
            return Files.move(src, target, options);
        }
        catch (IOException e) {
            if (e instanceof FileAlreadyExistsException || e instanceof AccessDeniedException) {
                throw new IORuntimeException(e);
            }
            PathMover.walkMove(src, target, options);
            RsPath.del(src);
            return target;
        }
    }

    private static void walkMove(Path src, Path target, CopyOption ... options) {
        try {
            Files.walkFileTree(src, new MoveVisitor(src, target, options));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

