/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.func;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Map;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.mutable.MutableEntry;
import top.redscorpion.core.map.reference.WeakConcurrentMap;
import top.redscorpion.core.reflect.lookup.RsLookup;
import top.redscorpion.core.reflect.method.RsMethodType;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsLambda;
import top.redscorpion.core.util.RsReflect;

public class LambdaFactory {
    private static final Map<MutableEntry<Class<?>, Executable>, Object> CACHE = new WeakConcurrentMap();

    public static <F> F build(Class<F> functionInterfaceType, Executable executable) {
        return LambdaFactory.build(functionInterfaceType, executable, null);
    }

    public static <F> F build(Class<F> functionInterfaceType, Executable executable, Class<?> declaringClass) {
        Assert.notNull(functionInterfaceType);
        Assert.notNull(executable);
        MutableEntry<Class<F>, Executable> cacheKey = new MutableEntry<Class<F>, Executable>(functionInterfaceType, executable);
        return (F)CACHE.computeIfAbsent(cacheKey, key -> LambdaFactory.doBuildWithoutCache(functionInterfaceType, executable, declaringClass));
    }

    private static <F> F doBuildWithoutCache(Class<F> funcType, Executable executable, Class<?> declaringClass) {
        RsReflect.setAccessible(executable);
        Method invokeMethod = RsLambda.getInvokeMethod(funcType);
        try {
            return (F)LambdaFactory.metaFactory(funcType, invokeMethod, executable, declaringClass).getTarget().invoke();
        }
        catch (Throwable e) {
            throw new RsException(e);
        }
    }

    private static CallSite metaFactory(Class<?> funcType, Method funcMethod, Executable executable, Class<?> declaringClass) throws LambdaConversionException {
        MethodHandles.Lookup caller = RsLookup.lookup(executable.getDeclaringClass());
        String invokeName = funcMethod.getName();
        MethodType invokedType = MethodType.methodType(funcType);
        Class<?>[] paramTypes = funcMethod.getParameterTypes();
        MethodType samMethodType = MethodType.methodType(funcMethod.getReturnType(), paramTypes);
        MethodHandle implMethodHandle = RsLookup.unreflect(executable);
        if (RsClass.isSerializable(funcType)) {
            return LambdaMetafactory.altMetafactory(caller, invokeName, invokedType, samMethodType, implMethodHandle, RsMethodType.methodType(executable, declaringClass), 1);
        }
        return LambdaMetafactory.metafactory(caller, invokeName, invokedType, samMethodType, implMethodHandle, RsMethodType.methodType(executable, declaringClass));
    }
}

