/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.date.format.parser;

import top.redscorpion.core.date.DateTime;
import top.redscorpion.core.date.format.parser.PredicateDateParser;
import top.redscorpion.core.date.format.parser.RegexDateParser;

public class DefaultRegexDateParser
implements PredicateDateParser {
    public static DefaultRegexDateParser INSTANCE = new DefaultRegexDateParser();
    private final RegexDateParser parser = this.createDefault();

    @Override
    public boolean test(CharSequence charSequence) {
        return true;
    }

    @Override
    public DateTime parse(CharSequence source) {
        return (DateTime)this.parser.parse(source);
    }

    private RegexDateParser createDefault() {
        String yearRegex = "(?<year>\\d{2,4})";
        String monthRegex = "(?<month>[jfmaasond][aepucoe][nbrylgptvc]\\w{0,6}|[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]{1,2}\u6708)";
        String dayRegex = "(?<day>\\d{1,2})(?:th)?";
        String weekRegexWithSuff = "((?<week>[mwfts][oeruha][ndieut](\\w{3,6})?|(\u661f\u671f|\u5468)[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u65e5])\\W+)?";
        String timeRegexWithPre = "((\\W+|T)(at\\s)?(?<hour>\\d{1,2})\\W(?<minute>\\d{1,2})(\\W(?<second>\\d{1,2}))?\u79d2?(?:[.,](?<ns>\\d{1,9}))?(?<zero>z)?(\\s?(?<m>[ap]m))?)?";
        String dateRegexMonthFirst = "(?<month>[jfmaasond][aepucoe][nbrylgptvc]\\w{0,6}|[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]{1,2}\u6708)\\W+(?<day>\\d{1,2})(?:th)?";
        String dateRegexDayFirst = "(?<day>\\d{1,2})(?:th)?\\W+(?<month>[jfmaasond][aepucoe][nbrylgptvc]\\w{0,6}|[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]{1,2}\u6708)";
        String zoneRegex = "\\s?(?<zone>[a-z ]*(\\s?[-+]\\d{1,2}:?(?:\\d{2})?)*(\\s?[(]?[a-z ]+[)]?)?)";
        String maskRegex = "(\\smsk m=[+-]\\d[.]\\d+)?";
        return RegexDateParser.of("(?<year>\\d{2,4})\\W(?<month>[jfmaasond][aepucoe][nbrylgptvc]\\w{0,6}|[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]{1,2}\u6708)\\W+(?<day>\\d{1,2})(?:th)?((\\W+|T)(at\\s)?(?<hour>\\d{1,2})\\W(?<minute>\\d{1,2})(\\W(?<second>\\d{1,2}))?\u79d2?(?:[.,](?<ns>\\d{1,9}))?(?<zero>z)?(\\s?(?<m>[ap]m))?)?\\s?(?<zone>[a-z ]*(\\s?[-+]\\d{1,2}:?(?:\\d{2})?)*(\\s?[(]?[a-z ]+[)]?)?)(\\smsk m=[+-]\\d[.]\\d+)?", "(?<year>\\d{2,4})\\W(?<month>\\d{1,2})(\\W(?<day>\\d{1,2}))?\u65e5?((\\W+|T)(at\\s)?(?<hour>\\d{1,2})\\W(?<minute>\\d{1,2})(\\W(?<second>\\d{1,2}))?\u79d2?(?:[.,](?<ns>\\d{1,9}))?(?<zero>z)?(\\s?(?<m>[ap]m))?)?\\s?(?<zone>[a-z ]*(\\s?[-+]\\d{1,2}:?(?:\\d{2})?)*(\\s?[(]?[a-z ]+[)]?)?)(\\smsk m=[+-]\\d[.]\\d+)?", "((?<week>[mwfts][oeruha][ndieut](\\w{3,6})?|(\u661f\u671f|\u5468)[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u65e5])\\W+)?(?<month>[jfmaasond][aepucoe][nbrylgptvc]\\w{0,6}|[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]{1,2}\u6708)\\W+(?<day>\\d{1,2})(?:th)?\\W+(?<year>\\d{2,4})((\\W+|T)(at\\s)?(?<hour>\\d{1,2})\\W(?<minute>\\d{1,2})(\\W(?<second>\\d{1,2}))?\u79d2?(?:[.,](?<ns>\\d{1,9}))?(?<zero>z)?(\\s?(?<m>[ap]m))?)?\\s?(?<zone>[a-z ]*(\\s?[-+]\\d{1,2}:?(?:\\d{2})?)*(\\s?[(]?[a-z ]+[)]?)?)(\\smsk m=[+-]\\d[.]\\d+)?", "((?<week>[mwfts][oeruha][ndieut](\\w{3,6})?|(\u661f\u671f|\u5468)[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u65e5])\\W+)?(?<month>[jfmaasond][aepucoe][nbrylgptvc]\\w{0,6}|[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]{1,2}\u6708)\\W+(?<day>\\d{1,2})(?:th)?((\\W+|T)(at\\s)?(?<hour>\\d{1,2})\\W(?<minute>\\d{1,2})(\\W(?<second>\\d{1,2}))?\u79d2?(?:[.,](?<ns>\\d{1,9}))?(?<zero>z)?(\\s?(?<m>[ap]m))?)?\\s?(?<zone>[a-z ]*(\\s?[-+]\\d{1,2}:?(?:\\d{2})?)*(\\s?[(]?[a-z ]+[)]?)?)\\W+(?<year>\\d{2,4})(\\smsk m=[+-]\\d[.]\\d+)?", "((?<week>[mwfts][oeruha][ndieut](\\w{3,6})?|(\u661f\u671f|\u5468)[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u65e5])\\W+)?(?<day>\\d{1,2})(?:th)?\\W+(?<month>[jfmaasond][aepucoe][nbrylgptvc]\\w{0,6}|[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]{1,2}\u6708)\\W+(?<year>\\d{2,4})((\\W+|T)(at\\s)?(?<hour>\\d{1,2})\\W(?<minute>\\d{1,2})(\\W(?<second>\\d{1,2}))?\u79d2?(?:[.,](?<ns>\\d{1,9}))?(?<zero>z)?(\\s?(?<m>[ap]m))?)?\\s?(?<zone>[a-z ]*(\\s?[-+]\\d{1,2}:?(?:\\d{2})?)*(\\s?[(]?[a-z ]+[)]?)?)(\\smsk m=[+-]\\d[.]\\d+)?", "(?<dayOrMonth>\\d{1,2}\\W\\d{1,2})\\W(?<year>\\d{4})((\\W+|T)(at\\s)?(?<hour>\\d{1,2})\\W(?<minute>\\d{1,2})(\\W(?<second>\\d{1,2}))?\u79d2?(?:[.,](?<ns>\\d{1,9}))?(?<zero>z)?(\\s?(?<m>[ap]m))?)?\\s?(?<zone>[a-z ]*(\\s?[-+]\\d{1,2}:?(?:\\d{2})?)*(\\s?[(]?[a-z ]+[)]?)?)(\\smsk m=[+-]\\d[.]\\d+)?", "^(?<number>\\d{4,19})$");
    }
}

