/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert;

import java.util.HashMap;
import top.redscorpion.core.map.BiMap;

public enum BasicType {
    BYTE,
    SHORT,
    INT,
    INTEGER,
    LONG,
    DOUBLE,
    FLOAT,
    BOOLEAN,
    CHAR,
    CHARACTER,
    STRING;

    private static final BiMap<Class<?>, Class<?>> WRAPPER_PRIMITIVE_MAP;

    public static Class<?> wrap(Class<?> clazz) {
        return BasicType.wrap(clazz, false);
    }

    public static Class<?> wrap(Class<?> clazz, boolean errorReturnNull) {
        if (null == clazz || !clazz.isPrimitive()) {
            return clazz;
        }
        Class<?> result = WRAPPER_PRIMITIVE_MAP.getInverse().get(clazz);
        return null == result ? (errorReturnNull ? null : clazz) : result;
    }

    public static Class<?> unWrap(Class<?> clazz) {
        if (null == clazz || clazz.isPrimitive()) {
            return clazz;
        }
        Class result = (Class)WRAPPER_PRIMITIVE_MAP.get(clazz);
        return null == result ? clazz : result;
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return WRAPPER_PRIMITIVE_MAP.containsKey(clazz);
    }

    static {
        WRAPPER_PRIMITIVE_MAP = new BiMap(new HashMap(8, 1.0f));
        WRAPPER_PRIMITIVE_MAP.put(Boolean.class, Boolean.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Byte.class, Byte.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Character.class, Character.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Double.class, Double.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Float.class, Float.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Integer.class, Integer.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Long.class, Long.TYPE);
        WRAPPER_PRIMITIVE_MAP.put(Short.class, Short.TYPE);
    }
}

