/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.collection.set;

import java.util.Collection;
import top.redscorpion.core.collection.set.SetFromMap;
import top.redscorpion.core.map.concurrent.SafeConcurrentHashMap;

public class ConcurrentHashSet<E>
extends SetFromMap<E> {
    private static final long serialVersionUID = 7997886765361607470L;

    public ConcurrentHashSet() {
        super(new SafeConcurrentHashMap());
    }

    public ConcurrentHashSet(int initialCapacity) {
        super(new SafeConcurrentHashMap(initialCapacity));
    }

    public ConcurrentHashSet(int initialCapacity, float loadFactor) {
        super(new SafeConcurrentHashMap(initialCapacity, loadFactor));
    }

    public ConcurrentHashSet(int initialCapacity, float loadFactor, int concurrencyLevel) {
        super(new SafeConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel));
    }

    public ConcurrentHashSet(Iterable<E> iter) {
        super(iter instanceof Collection ? new SafeConcurrentHashMap(((Collection)iter).size()) : new SafeConcurrentHashMap());
        if (iter instanceof Collection) {
            this.addAll((Collection)iter);
        } else {
            for (E e : iter) {
                this.add(e);
            }
        }
    }
}

