/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.bean;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import top.redscorpion.core.bean.BeanException;
import top.redscorpion.core.bean.PropDesc;
import top.redscorpion.core.exception.CloneException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.reflect.RsConstructor;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsBean;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsConvert;
import top.redscorpion.core.util.RsList;

public class DynaBean
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> beanClass;
    private Object bean;

    public static DynaBean of(Object bean) {
        return new DynaBean(bean);
    }

    public DynaBean(Object bean) {
        Assert.notNull(bean);
        if (bean instanceof DynaBean) {
            this.bean = ((DynaBean)bean).getBean();
            this.beanClass = ((DynaBean)bean).getBeanClass();
        } else if (bean instanceof Class) {
            this.bean = RsConstructor.newInstance((Class)bean, new Object[0]);
            this.beanClass = (Class)bean;
        } else {
            this.bean = bean;
            this.beanClass = RsClass.getClass(bean);
        }
    }

    public <T> T getProperty(String expression) {
        return RsBean.getProperty(this.bean, expression);
    }

    public <T> T get(String fieldName) throws BeanException {
        if (Map.class.isAssignableFrom(this.beanClass)) {
            return (T)((Map)this.bean).get(fieldName);
        }
        if (this.bean instanceof Collection) {
            try {
                return RsColl.get((Collection)this.bean, Integer.parseInt(fieldName));
            }
            catch (NumberFormatException e) {
                return (T)RsColl.map((Collection)this.bean, beanEle -> DynaBean.of(beanEle).get(fieldName), false);
            }
        }
        if (RsArray.isArray(this.bean)) {
            try {
                return (T)RsArray.get(this.bean, Integer.parseInt(fieldName));
            }
            catch (NumberFormatException e) {
                return (T)RsArray.map(this.bean, Object.class, beanEle -> DynaBean.of(beanEle).get(fieldName));
            }
        }
        PropDesc prop = RsBean.getBeanDesc(this.beanClass).getProp(fieldName);
        if (null == prop) {
            return null;
        }
        return (T)prop.getValue(this.bean, false);
    }

    public DynaBean set(String fieldName, Object value) throws BeanException {
        if (Map.class.isAssignableFrom(this.beanClass)) {
            ((Map)this.bean).put(fieldName, value);
        } else if (this.bean instanceof List) {
            RsList.setOrPadding((List)this.bean, RsConvert.toInt(fieldName), value);
        } else if (RsArray.isArray(this.bean)) {
            this.bean = RsArray.setOrPadding(this.bean, RsConvert.toInt(fieldName), value);
        } else {
            PropDesc prop = RsBean.getBeanDesc(this.beanClass).getProp(fieldName);
            if (null == prop) {
                throw new BeanException("No public field or set method for '{}'", new Object[]{fieldName});
            }
            prop.setValue(this.bean, value, false, false);
        }
        return this;
    }

    public <T> T getBean() {
        return (T)this.bean;
    }

    public <T> Class<T> getBeanClass() {
        return this.beanClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bean == null ? 0 : this.bean.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DynaBean other = (DynaBean)obj;
        if (this.bean == null) {
            return other.bean == null;
        }
        return this.bean.equals(other.bean);
    }

    public String toString() {
        return this.bean.toString();
    }

    public DynaBean clone() {
        try {
            return (DynaBean)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CloneException(e);
        }
    }
}

