/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.writer;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.OpenOption;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.IgnoredErrorType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.CellReference;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsBean;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.poi.POIException;
import top.redscorpion.poi.excel.ExcelBase;
import top.redscorpion.poi.excel.RowGroup;
import top.redscorpion.poi.excel.RsSheet;
import top.redscorpion.poi.excel.RsWorkbook;
import top.redscorpion.poi.excel.SimpleClientAnchor;
import top.redscorpion.poi.excel.cell.RsCell;
import top.redscorpion.poi.excel.cell.RsCellRange;
import top.redscorpion.poi.excel.shape.ExcelPicType;
import top.redscorpion.poi.excel.shape.RsExcelPic;
import top.redscorpion.poi.excel.style.Align;
import top.redscorpion.poi.excel.style.DefaultStyleSet;
import top.redscorpion.poi.excel.style.LineStyle;
import top.redscorpion.poi.excel.style.ShapeConfig;
import top.redscorpion.poi.excel.style.StyleSet;
import top.redscorpion.poi.excel.writer.ExcelWriteConfig;
import top.redscorpion.poi.excel.writer.RsDataValidation;
import top.redscorpion.poi.excel.writer.RsExcelDrawing;
import top.redscorpion.poi.excel.writer.SheetDataWriter;
import top.redscorpion.poi.excel.writer.SheetTemplateWriter;

public class ExcelWriter
extends ExcelBase<ExcelWriter, ExcelWriteConfig> {
    private StyleSet styleSet;
    private SheetDataWriter sheetDataWriter;
    private SheetTemplateWriter sheetTemplateWriter;

    public ExcelWriter() {
        this(true);
    }

    public ExcelWriter(boolean isXlsx) {
        this(RsWorkbook.createBook(isXlsx), (String)null);
    }

    public ExcelWriter(String templateFilePath) {
        this(templateFilePath, (String)null);
    }

    public ExcelWriter(boolean isXlsx, String sheetName) {
        this(RsWorkbook.createBook(isXlsx), sheetName);
    }

    public ExcelWriter(String templateFilePath, String sheetName) {
        this(RsFile.file(templateFilePath), sheetName);
    }

    public ExcelWriter(File templateFile) {
        this(templateFile, (String)null);
    }

    public ExcelWriter(File templateFile, String sheetName) {
        this(RsWorkbook.createBookForWriter(templateFile), sheetName);
        if (!RsFile.exists(templateFile)) {
            this.targetFile = templateFile;
        } else {
            this.sheetTemplateWriter = new SheetTemplateWriter(this.sheet, (ExcelWriteConfig)this.config);
        }
    }

    public ExcelWriter(Workbook templateWorkbook, String sheetName) {
        this(RsSheet.getOrCreateSheet(templateWorkbook, sheetName));
    }

    public ExcelWriter(Sheet sheet) {
        super(new ExcelWriteConfig(), sheet);
        this.styleSet = new DefaultStyleSet(this.workbook);
    }

    @Override
    public ExcelWriter setConfig(ExcelWriteConfig config) {
        return (ExcelWriter)super.setConfig(config);
    }

    public ExcelWriter reset() {
        this.sheetDataWriter = null;
        return this;
    }

    @Override
    public void close() {
        if (null != this.targetFile) {
            this.flush();
        }
        this.closeWithoutFlush();
    }

    protected void closeWithoutFlush() {
        super.close();
        this.reset();
        this.styleSet = null;
    }

    @Override
    public ExcelWriter setSheet(int sheetIndex) {
        super.setSheet(sheetIndex);
        return this.reset();
    }

    @Override
    public ExcelWriter setSheet(String sheetName) {
        super.setSheet(sheetName);
        return this.reset();
    }

    @Override
    public ExcelWriter renameSheet(String sheetName) {
        return this.renameSheet(this.workbook.getSheetIndex(this.sheet), sheetName);
    }

    public ExcelWriter renameSheet(int sheet, String sheetName) {
        this.workbook.setSheetName(sheet, sheetName);
        return this;
    }

    public ExcelWriter autoSizeColumnAll(boolean useMergedCells, float widthRatio) {
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.autoSizeColumn(i, useMergedCells, widthRatio);
        }
        return this;
    }

    public ExcelWriter autoSizeColumn(int columnIndex, boolean useMergedCells, float widthRatio) {
        if (widthRatio > 0.0f) {
            this.sheet.setColumnWidth(columnIndex, (int)((float)this.sheet.getColumnWidth(columnIndex) * widthRatio));
        } else {
            this.sheet.autoSizeColumn(columnIndex, useMergedCells);
        }
        return this;
    }

    public ExcelWriter disableDefaultStyle() {
        return this.setStyleSet(null);
    }

    public ExcelWriter setStyleSet(StyleSet styleSet) {
        this.styleSet = styleSet;
        if (null != this.sheetDataWriter) {
            this.sheetDataWriter.setStyleSet(styleSet);
        }
        return this;
    }

    public StyleSet getStyleSet() {
        return this.styleSet;
    }

    public int getCurrentRow() {
        return null == this.sheetDataWriter ? 0 : this.sheetDataWriter.getCurrentRow();
    }

    public ExcelWriter setCurrentRow(int rowIndex) {
        this.getSheetDataWriter().setCurrentRow(rowIndex);
        return this;
    }

    public ExcelWriter setCurrentRowToEnd() {
        return this.setCurrentRow(this.getRowCount());
    }

    public ExcelWriter passCurrentRow() {
        this.getSheetDataWriter().passAndGet();
        return this;
    }

    public ExcelWriter passRows(int rowNum) {
        this.getSheetDataWriter().passRowsAndGet(rowNum);
        return this;
    }

    public ExcelWriter resetRow() {
        this.getSheetDataWriter().resetRow();
        return this;
    }

    public ExcelWriter setTargetFile(File targetFile) {
        this.targetFile = targetFile;
        return this;
    }

    public ExcelWriter setFreezePane(int rowSplit) {
        return this.setFreezePane(0, rowSplit);
    }

    public ExcelWriter setFreezePane(int colSplit, int rowSplit) {
        this.getSheet().createFreezePane(colSplit, rowSplit);
        return this;
    }

    public ExcelWriter setColumnWidth(int columnIndex, int width) {
        if (columnIndex < 0) {
            this.sheet.setDefaultColumnWidth(width);
        } else {
            this.sheet.setColumnWidth(columnIndex, width * 256);
        }
        return this;
    }

    public ExcelWriter setDefaultRowHeight(int height) {
        return this.setRowHeight(-1, height);
    }

    public ExcelWriter setRowHeight(int rowNum, int height) {
        if (rowNum < 0) {
            this.sheet.setDefaultRowHeightInPoints((float)height);
        } else {
            Row row = this.sheet.getRow(rowNum);
            if (null != row) {
                row.setHeightInPoints((float)height);
            }
        }
        return this;
    }

    public ExcelWriter setHeaderOrFooter(String text, Align align, boolean isFooter) {
        Footer headerFooter = isFooter ? this.sheet.getFooter() : this.sheet.getHeader();
        switch (align) {
            case LEFT: {
                headerFooter.setLeft(text);
                break;
            }
            case RIGHT: {
                headerFooter.setRight(text);
                break;
            }
            case CENTER: {
                headerFooter.setCenter(text);
                break;
            }
        }
        return this;
    }

    public ExcelWriter addIgnoredErrors(CellRangeAddress cellRangeAddress, IgnoredErrorType ... ignoredErrorTypes) throws UnsupportedOperationException {
        RsSheet.addIgnoredErrors(this.sheet, cellRangeAddress, ignoredErrorTypes);
        return this;
    }

    public ExcelWriter addSelect(int x, int y, String ... selectList) {
        return this.addSelect(new CellRangeAddressList(y, y, x, x), selectList);
    }

    public ExcelWriter addSelect(CellRangeAddressList regions, String ... selectList) {
        RsDataValidation.addSelect(this.sheet, regions, selectList);
        return this;
    }

    public ExcelWriter addValidationData(DataValidation dataValidation) {
        this.sheet.addValidationData(dataValidation);
        return this;
    }

    public ExcelWriter merge(int lastColumn) {
        return this.merge(lastColumn, null);
    }

    public ExcelWriter merge(int lastColumn, Object content) {
        return this.merge(lastColumn, content, true);
    }

    public ExcelWriter merge(int lastColumn, Object content, boolean isSetHeaderStyle) {
        this.checkClosed();
        int rowIndex = this.getCurrentRow();
        this.merge(RsCellRange.ofSingleRow(rowIndex, lastColumn), content, isSetHeaderStyle);
        if (null != content) {
            this.passCurrentRow();
        }
        return this;
    }

    public ExcelWriter merge(CellRangeAddress cellRangeAddress, Object content, boolean isSetHeaderStyle) {
        this.checkClosed();
        CellStyle style = null;
        if (null != this.styleSet) {
            style = this.styleSet.getStyleFor(new CellReference(cellRangeAddress.getFirstRow(), cellRangeAddress.getFirstColumn()), content, isSetHeaderStyle);
        }
        return this.merge(cellRangeAddress, content, style);
    }

    public ExcelWriter merge(CellRangeAddress cellRangeAddress, Object content, CellStyle cellStyle) {
        this.checkClosed();
        RsCell.mergingCells(this.getSheet(), cellRangeAddress, cellStyle);
        if (null != content) {
            Cell cell = this.getOrCreateCell(cellRangeAddress.getFirstColumn(), cellRangeAddress.getFirstRow());
            RsCell.setCellValue(cell, content, cellStyle, ((ExcelWriteConfig)this.config).getCellEditor());
        }
        return this;
    }

    public ExcelWriter write(Iterable<?> data) {
        return this.write(data, 0 == this.getCurrentRow());
    }

    public ExcelWriter write(Iterable<?> data, boolean isWriteKeyAsHead) {
        this.checkClosed();
        boolean isFirst = true;
        for (Object object : data) {
            this.writeRow(object, isFirst && isWriteKeyAsHead);
            if (!isFirst) continue;
            isFirst = false;
        }
        return this;
    }

    public ExcelWriter write(Iterable<?> data, Comparator<String> comparator) {
        this.checkClosed();
        boolean isFirstRow = true;
        for (Object obj : data) {
            Map<String, Object> map;
            if (isFirstRow) {
                if (obj instanceof Map) {
                    map = new TreeMap(comparator);
                    map.putAll((Map)obj);
                } else {
                    map = RsBean.beanToMap(obj, new TreeMap<String, Object>(comparator), false, false);
                }
            } else {
                map = obj instanceof Map ? (TreeMap)obj : RsBean.beanToMap(obj, new HashMap<String, Object>(), false, false);
            }
            this.writeRow(map, isFirstRow);
            if (!isFirstRow) continue;
            isFirstRow = false;
        }
        return this;
    }

    public ExcelWriter writeHeader(RowGroup rowGroup) {
        return this.writeHeader(0, this.getCurrentRow(), 1, rowGroup);
    }

    public ExcelWriter writeHeader(int x, int y, int rowCount, RowGroup rowGroup) {
        this.checkClosed();
        this.getSheetDataWriter().writeHeader(x, y, rowCount, rowGroup);
        return this;
    }

    public ExcelWriter writePic(File imgFile, int col1, int row1, int col2, int row2) {
        return this.writePic(imgFile, new SimpleClientAnchor(col1, row1, col2, row2));
    }

    public ExcelWriter writePic(File imgFile, SimpleClientAnchor clientAnchor) {
        return this.writePic(imgFile, RsExcelPic.getPicType(imgFile), clientAnchor);
    }

    public ExcelWriter writePic(File imgFile, ExcelPicType imgType, SimpleClientAnchor clientAnchor) {
        return this.writePic(RsFile.readBytes(imgFile), imgType, clientAnchor);
    }

    public ExcelWriter writePic(byte[] pictureData, ExcelPicType imgType, SimpleClientAnchor clientAnchor) {
        RsExcelDrawing.drawingPic(this.sheet, pictureData, imgType, clientAnchor);
        return this;
    }

    public ExcelWriter writeLineShape(SimpleClientAnchor clientAnchor) {
        return this.writeSimpleShape(clientAnchor, ShapeConfig.of());
    }

    public ExcelWriter writeLineShape(SimpleClientAnchor clientAnchor, LineStyle lineStyle, int lineWidth, Color lineColor) {
        return this.writeSimpleShape(clientAnchor, ShapeConfig.of().setLineStyle(lineStyle).setLineWidth(lineWidth).setLineColor(lineColor));
    }

    public ExcelWriter writeSimpleShape(SimpleClientAnchor clientAnchor, ShapeConfig shapeConfig) {
        RsExcelDrawing.drawingSimpleShape(this.sheet, clientAnchor, shapeConfig);
        return this;
    }

    public ExcelWriter writeHeaderRow(Iterable<?> rowData) {
        this.checkClosed();
        this.getSheetDataWriter().writeHeaderRow(rowData);
        return this;
    }

    public ExcelWriter fillOnce(Map<?, ?> rowMap) {
        this.checkClosed();
        Assert.notNull(this.sheetTemplateWriter, () -> new POIException("No template for this writer!"));
        this.sheetTemplateWriter.fillOnce(rowMap);
        return this;
    }

    public ExcelWriter writeRow(Object rowBean, boolean isWriteKeyAsHead) {
        this.checkClosed();
        if (null != this.sheetTemplateWriter) {
            this.sheetTemplateWriter.fillRow(rowBean);
            return this;
        }
        this.getSheetDataWriter().writeRow(rowBean, isWriteKeyAsHead);
        return this;
    }

    public ExcelWriter writeRow(Iterable<?> rowData) {
        this.checkClosed();
        this.getSheetDataWriter().writeRow(rowData);
        return this;
    }

    public ExcelWriter writeCol(Map<?, ? extends Iterable<?>> colMap, boolean isWriteKeyAsHead) {
        return this.writeCol(colMap, 0, isWriteKeyAsHead);
    }

    public ExcelWriter writeCol(Map<?, ? extends Iterable<?>> colMap, int startColIndex, boolean isWriteKeyAsHead) {
        for (Object k : colMap.keySet()) {
            Iterable<?> v = colMap.get(k);
            if (v == null) continue;
            this.writeCol(isWriteKeyAsHead ? k : null, startColIndex, v, startColIndex != colMap.size() - 1);
            ++startColIndex;
        }
        return this;
    }

    public ExcelWriter writeCol(Object headerVal, Iterable<?> colData, boolean isResetRowIndex) {
        return this.writeCol(headerVal, 0, colData, isResetRowIndex);
    }

    public ExcelWriter writeCol(Object headerVal, int colIndex, Iterable<?> colData, boolean isResetRowIndex) {
        this.checkClosed();
        int currentRowIndex = this.getCurrentRow();
        if (null != headerVal) {
            this.writeCellValue(colIndex, currentRowIndex, headerVal, true);
            ++currentRowIndex;
        }
        for (Object colDatum : colData) {
            this.writeCellValue(colIndex, currentRowIndex, colDatum);
            ++currentRowIndex;
        }
        if (!isResetRowIndex) {
            this.setCurrentRow(currentRowIndex);
        }
        return this;
    }

    public ExcelWriter writeCellValue(String locationRef, Object value) {
        CellReference cellReference = new CellReference(locationRef);
        return this.writeCellValue(cellReference.getCol(), cellReference.getRow(), value);
    }

    public ExcelWriter writeCellValue(int x, int y, Object value) {
        return this.writeCellValue(x, y, value, false);
    }

    public ExcelWriter writeCellValue(int x, int y, Object value, boolean isHeader) {
        Cell cell = this.getOrCreateCell(x, y);
        RsCell.setCellValue(cell, value, this.styleSet, isHeader, ((ExcelWriteConfig)this.config).getCellEditor());
        return this;
    }

    public ExcelWriter setStyle(CellStyle style, String locationRef) {
        CellReference cellReference = new CellReference(locationRef);
        return this.setStyle(style, cellReference.getCol(), cellReference.getRow());
    }

    public ExcelWriter setStyle(CellStyle style, int x, int y) {
        Cell cell = this.getOrCreateCell(x, y);
        cell.setCellStyle(style);
        return this;
    }

    public ExcelWriter setRowStyle(int y, CellStyle style) {
        this.getOrCreateRow(y).setRowStyle(style);
        return this;
    }

    public ExcelWriter setRowStyleIfHasData(int y, CellStyle style) {
        if (y < 0) {
            throw new IllegalArgumentException("Invalid row number (" + y + ")");
        }
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.setStyle(style, i, y);
        }
        return this;
    }

    public ExcelWriter setColumnStyle(int x, CellStyle style) {
        this.sheet.setDefaultColumnStyle(x, style);
        return this;
    }

    public ExcelWriter setColumnStyleIfHasData(int x, int y, CellStyle style) {
        if (x < 0) {
            throw new IllegalArgumentException("Invalid column number (" + x + ")");
        }
        if (y < 0) {
            throw new IllegalArgumentException("Invalid row number (" + y + ")");
        }
        int rowCount = this.getRowCount();
        for (int i = y; i < rowCount; ++i) {
            this.setStyle(style, x, i);
        }
        return this;
    }

    public ExcelWriter flush() throws IORuntimeException {
        return this.flush(false);
    }

    public ExcelWriter flush(boolean override) throws IORuntimeException {
        Assert.notNull(this.targetFile, "[targetFile] is null, and you must call setTargetFile(File) first.", new Object[0]);
        return this.flush(this.targetFile, override);
    }

    public ExcelWriter flush(File targetFile, boolean override) throws IORuntimeException {
        Assert.notNull(targetFile, "targetFile is null!", new Object[0]);
        if (RsFile.exists(targetFile) && !override) {
            throw new IORuntimeException("File to write exist: " + targetFile);
        }
        return this.flush(RsFile.getOutputStream(targetFile, new OpenOption[0]), true);
    }

    public ExcelWriter flush(OutputStream out) throws IORuntimeException {
        return this.flush(out, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExcelWriter flush(OutputStream out, boolean isCloseOut) throws IORuntimeException {
        this.checkClosed();
        try {
            this.workbook.write(out);
            out.flush();
            if (!isCloseOut) return this;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                if (!isCloseOut) throw throwable;
                RsIo.closeQuietly(out);
                throw throwable;
            }
        }
        RsIo.closeQuietly(out);
        return this;
    }

    private SheetDataWriter getSheetDataWriter() {
        if (null == this.sheetDataWriter) {
            this.sheetDataWriter = new SheetDataWriter(this.sheet, (ExcelWriteConfig)this.config, this.styleSet);
        }
        return this.sheetDataWriter;
    }
}

