/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.server.servlet;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsFileName;
import top.redscorpion.core.util.RsNet;
import top.redscorpion.core.util.RsString;

public class RsServlet {
    public static String getClientIp(HttpServletRequest request, String ... otherHeaderNames) {
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (RsArray.isNotEmpty(otherHeaderNames)) {
            headers = RsArray.addAll(headers, otherHeaderNames);
        }
        return RsServlet.getClientIpByHeader(request, headers);
    }

    public static String getClientIpByHeader(HttpServletRequest request, String ... headerNames) {
        String ip;
        for (String header : headerNames) {
            ip = request.getHeader(header);
            if (RsNet.isUnknown(ip)) continue;
            return RsNet.getMultistageReverseProxyIp(ip);
        }
        ip = request.getRemoteAddr();
        return RsNet.getMultistageReverseProxyIp(ip);
    }

    public static void view(String filePath, String fileType, HttpServletResponse response) {
        File file = new File(filePath);
        RsServlet.view(file, false, fileType, null, null, "UTF-8", response);
    }

    public static void view(File file, String fileType, HttpServletResponse response) {
        RsServlet.view(file, false, fileType, null, null, "UTF-8", response);
    }

    public static void view(String filePath, String fileType, String fileName, HttpServletResponse response) {
        File file = new File(filePath);
        RsServlet.view(file, false, fileType, fileName, null, "UTF-8", response);
    }

    public static void view(File file, String fileType, String fileName, HttpServletResponse response) {
        RsServlet.view(file, false, fileType, fileName, null, "UTF-8", response);
    }

    public static void view(String filePath, boolean preview, String fileType, HttpServletResponse response) {
        File file = new File(filePath);
        RsServlet.view(file, preview, fileType, null, null, "UTF-8", response);
    }

    public static void view(File file, boolean preview, String fileType, HttpServletResponse response) {
        RsServlet.view(file, preview, fileType, null, null, "UTF-8", response);
    }

    public static void view(String filePath, boolean preview, String fileType, String fileName, HttpServletResponse response) {
        File file = new File(filePath);
        RsServlet.view(file, preview, fileType, fileName, null, "UTF-8", response);
    }

    public static void view(File file, boolean preview, String fileType, String fileName, HttpServletResponse response) {
        RsServlet.view(file, preview, fileType, fileName, null, "UTF-8", response);
    }

    public static void view(String filePath, boolean preview, String fileType, Long fileSize, HttpServletResponse response) {
        File file = new File(filePath);
        RsServlet.view(file, preview, fileType, null, fileSize, "UTF-8", response);
    }

    public static void view(File file, boolean preview, String fileType, Long fileSize, HttpServletResponse response) {
        RsServlet.view(file, preview, fileType, null, fileSize, "UTF-8", response);
    }

    public static void view(String filePath, boolean preview, String fileType, String fileName, Long fileSize, HttpServletResponse response) {
        File file = new File(filePath);
        RsServlet.view(file, preview, fileType, fileName, fileSize, "UTF-8", response);
    }

    public static void view(File file, boolean preview, String fileType, String fileName, Long fileSize, HttpServletResponse response) {
        RsServlet.view(file, preview, fileType, fileName, fileSize, "UTF-8", response);
    }

    public static void view(String filePath, boolean preview, String fileType, String fileName, Long fileSize, String charset, HttpServletResponse response) {
        File file = new File(filePath);
        RsServlet.view(file, preview, fileType, fileName, fileSize, charset, response);
    }

    public static void view(File file, boolean preview, String fileType, String fileName, Long fileSize, String charset, HttpServletResponse response) {
        if (!file.exists()) {
            throw new RsException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        if (!preview) {
            if (RsString.isBlank(fileName)) {
                fileName = RsFileName.getName(file);
            } else {
                String ext = "." + RsFileName.extName(file);
                if (fileName.indexOf(".") == -1 || !fileName.endsWith(ext)) {
                    fileName = fileName + ext;
                }
            }
            try {
                response.addHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, charset));
            }
            catch (UnsupportedEncodingException ext) {
                // empty catch block
            }
        }
        if (fileSize != null) {
            response.setContentLengthLong(fileSize.longValue());
        }
        response.setContentType(fileType + ";charset=" + charset);
        response.addHeader("Accept-Ranges", "bytes");
        if (fileSize != null && fileSize > 0L) {
            response.addHeader("Content-Range", "bytes 0-" + (fileSize - 1L) + "/" + fileSize);
        }
        response.setBufferSize(0xA00000);
        try (FileInputStream is = new FileInputStream(file);
             BufferedInputStream bis = new BufferedInputStream(is);){
            int bytesRead;
            ServletOutputStream out = response.getOutputStream();
            byte[] buf = new byte[1024];
            while ((bytesRead = bis.read(buf)) > 0) {
                out.write(buf, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new RsException("\u8bfb\u53d6\u6587\u4ef6\u51fa\u9519");
        }
    }
}

