/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.okhttp;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import top.redscorpion.core.io.stream.EmptyInputStream;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.http.GlobalCompressStreamRegister;
import top.redscorpion.http.RsHttp;
import top.redscorpion.http.client.Request;
import top.redscorpion.http.client.Response;
import top.redscorpion.http.meta.HeaderName;

public class OkHttpResponse
implements Response {
    private final okhttp3.Response rawRes;
    private final Charset requestCharset;
    private final top.redscorpion.http.client.body.ResponseBody body;

    public OkHttpResponse(okhttp3.Response rawRes, Request message) {
        this.rawRes = rawRes;
        this.requestCharset = message.charset();
        this.body = message.method().isIgnoreBody() ? null : new top.redscorpion.http.client.body.ResponseBody(this, this.bodyStream());
    }

    @Override
    public int getStatus() {
        return this.rawRes.code();
    }

    @Override
    public String header(String name) {
        return this.rawRes.header(name);
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.rawRes.headers().toMultimap();
    }

    @Override
    public Charset charset() {
        return RsObject.defaultIfNull(Response.super.charset(), this.requestCharset);
    }

    @Override
    public InputStream bodyStream() {
        ResponseBody body = this.rawRes.body();
        if (null == body) {
            return EmptyInputStream.INSTANCE;
        }
        return GlobalCompressStreamRegister.INSTANCE.wrapStream(body.byteStream(), this.rawRes.header(HeaderName.CONTENT_ENCODING.getValue()));
    }

    @Override
    public OkHttpResponse sync() {
        if (null != this.body) {
            this.body.sync();
        }
        RsIo.closeQuietly(new AutoCloseable[]{this.rawRes});
        return this;
    }

    @Override
    public top.redscorpion.http.client.body.ResponseBody body() {
        return this.body;
    }

    @Override
    public void close() {
        RsIo.closeQuietly(new AutoCloseable[]{this.rawRes});
    }

    public String toString() {
        return RsHttp.toString(this);
    }
}

