/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.jdk;

import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsUrl;
import top.redscorpion.http.HttpException;
import top.redscorpion.http.client.ClientConfig;
import top.redscorpion.http.client.Request;
import top.redscorpion.http.client.RequestContext;
import top.redscorpion.http.client.body.HttpBody;
import top.redscorpion.http.client.engine.AbstractClientEngine;
import top.redscorpion.http.client.engine.jdk.JdkCookieManager;
import top.redscorpion.http.client.engine.jdk.JdkHttpConnection;
import top.redscorpion.http.client.engine.jdk.JdkHttpResponse;
import top.redscorpion.http.meta.HeaderName;
import top.redscorpion.http.meta.HttpStatus;
import top.redscorpion.http.meta.Method;
import top.redscorpion.http.proxy.ProxyInfo;

public class JdkClientEngine
extends AbstractClientEngine {
    private JdkCookieManager cookieManager;

    public JdkCookieManager getCookieManager() {
        return this.cookieManager;
    }

    @Override
    public JdkHttpResponse send(Request message) {
        return this.doSend(new RequestContext(message));
    }

    @Override
    public Object getRawEngine() {
        return this;
    }

    @Override
    public void close() {
        this.cookieManager = null;
    }

    @Override
    protected void reset() {
    }

    @Override
    protected void initEngine() {
        this.cookieManager = null != this.config && this.config.isUseCookieManager() ? new JdkCookieManager() : new JdkCookieManager(null);
    }

    private JdkHttpResponse doSend(RequestContext context) {
        Request message = context.getRequest();
        JdkHttpConnection conn = this.buildConn(message);
        try {
            this.doSend(conn, message);
        }
        catch (IOException e) {
            RsIo.closeQuietly(conn);
            throw new HttpException(e);
        }
        int maxRedirects = message.maxRedirects();
        if (maxRedirects > 0 && context.getRedirectCount() < maxRedirects) {
            int code;
            try {
                code = conn.getCode();
            }
            catch (IOException e) {
                conn.closeQuietly();
                throw new HttpException(e);
            }
            if (HttpStatus.isRedirected(code)) {
                if (307 != code) {
                    message.method(Method.GET);
                }
                message.locationTo(conn.header(HeaderName.LOCATION));
                context.incrementRedirectCount();
                return this.doSend(context);
            }
        }
        return new JdkHttpResponse(conn, this.cookieManager, context.getRequest());
    }

    private void doSend(JdkHttpConnection conn, Request message) throws IOException {
        HttpBody body = message.handledBody();
        if (null != body) {
            body.writeClose(conn.getOutputStream());
            return;
        }
        conn.connect();
    }

    private JdkHttpConnection buildConn(Request message) {
        ClientConfig config = RsObject.defaultIfNull(this.config, ClientConfig::of);
        URL url = message.handledUrl().toUrl();
        Proxy proxy = null;
        ProxyInfo proxyInfo = config.getProxy();
        if (null != proxyInfo) {
            proxy = proxyInfo.selectFirst(RsUrl.toUri(url));
        }
        JdkHttpConnection conn = (JdkHttpConnection)JdkHttpConnection.of(url, proxy).setConnectTimeout(config.getConnectionTimeout()).setReadTimeout(config.getReadTimeout()).setMethod(message.method()).setSslInfo(config.getSslInfo()).setInstanceFollowRedirects(false).setDisableCache(config.isDisableCache()).header(message.headers(), true);
        if (!message.method().isIgnoreBody()) {
            long contentLength = message.contentLength();
            if (contentLength > 0L) {
                conn.setFixedLengthStreamingMode(contentLength);
            } else if (message.isChunked()) {
                conn.setChunkedStreamingMode(4096);
            }
        }
        if (null == message.header(HeaderName.COOKIE) && null != this.cookieManager) {
            conn.header(this.cookieManager.loadForRequest(conn), false);
        }
        return conn;
    }
}

