/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.httpclient5;

import java.io.Closeable;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.message.BasicHeader;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.net.url.UrlBuilder;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.http.GlobalHeaders;
import top.redscorpion.http.HttpException;
import top.redscorpion.http.client.ApacheHttpClientConfig;
import top.redscorpion.http.client.ClientConfig;
import top.redscorpion.http.client.Request;
import top.redscorpion.http.client.Response;
import top.redscorpion.http.client.body.HttpBody;
import top.redscorpion.http.client.cookie.InMemoryCookieStore;
import top.redscorpion.http.client.engine.AbstractClientEngine;
import top.redscorpion.http.client.engine.httpclient5.HttpClient5BodyEntity;
import top.redscorpion.http.client.engine.httpclient5.HttpClient5CookieStore;
import top.redscorpion.http.client.engine.httpclient5.HttpClient5Response;
import top.redscorpion.http.client.engine.httpclient5.TlsSocketStrategyBuilder;
import top.redscorpion.http.meta.HeaderName;
import top.redscorpion.http.proxy.ProxyInfo;
import top.redscorpion.http.ssl.SSLInfo;

public class HttpClient5Engine
extends AbstractClientEngine {
    private CloseableHttpClient engine;

    public HttpClient5Engine() {
        Assert.notNull(CloseableHttpClient.class);
    }

    @Override
    public Response send(Request message) {
        ClassicHttpResponse response;
        this.initEngine();
        ClassicHttpRequest request = HttpClient5Engine.buildRequest(message);
        try {
            response = this.engine.executeOpen(null, request, null);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
        return new HttpClient5Response(response, message);
    }

    @Override
    public Object getRawEngine() {
        return this.engine;
    }

    @Override
    public void close() throws IOException {
        RsIo.nullSafeClose((Closeable)this.engine);
    }

    @Override
    protected void reset() {
        RsIo.closeQuietly(new AutoCloseable[]{this.engine});
        this.engine = null;
    }

    @Override
    protected void initEngine() {
        if (null != this.engine) {
            return;
        }
        HttpClientBuilder clientBuilder = HttpClients.custom();
        ClientConfig config = RsObject.defaultIfNull(this.config, ApacheHttpClientConfig::of);
        clientBuilder.setConnectionManager((HttpClientConnectionManager)HttpClient5Engine.buildConnectionManager(config));
        clientBuilder.setDefaultRequestConfig(HttpClient5Engine.buildDefaultRequestConfig(config));
        if (config.isDisableCache()) {
            clientBuilder.disableAuthCaching();
        }
        clientBuilder.setDefaultHeaders(HttpClient5Engine.toHeaderList(GlobalHeaders.INSTANCE.headers()));
        HttpClient5Engine.setProxy(clientBuilder, config);
        if (config.isUseCookieManager()) {
            this.cookieStore = new InMemoryCookieStore();
            clientBuilder.setDefaultCookieStore((CookieStore)new HttpClient5CookieStore(this.cookieStore));
        }
        this.engine = clientBuilder.build();
    }

    private static ClassicHttpRequest buildRequest(Request message) {
        UrlBuilder url = message.handledUrl();
        Assert.notNull(url, "Request URL must be not null!", new Object[0]);
        HttpUriRequestBase request = new HttpUriRequestBase(message.method().name(), url.toUri());
        request.setConfig(HttpClient5Engine.buildRequestConfig(message));
        request.setHeaders(HttpClient5Engine.toHeaderList(message.headers()).toArray(new Header[0]));
        HttpBody body = message.handledBody();
        if (null != body) {
            request.setEntity((HttpEntity)new HttpClient5BodyEntity(message.header(HeaderName.CONTENT_TYPE), message.contentEncoding(), message.isChunked(), body));
        }
        return request;
    }

    private static List<Header> toHeaderList(Map<String, ? extends Collection<String>> headersMap) {
        ArrayList<Header> result = new ArrayList<Header>();
        headersMap.forEach((k, v1) -> v1.forEach(v2 -> result.add((Header)new BasicHeader(k, v2))));
        return result;
    }

    private static PoolingHttpClientConnectionManager buildConnectionManager(ClientConfig config) {
        int connectionTimeout;
        PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
        SSLInfo sslInfo = config.getSslInfo();
        if (null != sslInfo) {
            connectionManagerBuilder.setTlsSocketStrategy(TlsSocketStrategyBuilder.of().setSslContext(sslInfo.getSslContext()).setSupportedProtocols(sslInfo.getProtocols()).setHostnameVerifier(sslInfo.getHostnameVerifier()).build());
        }
        if ((connectionTimeout = config.getConnectionTimeout()) > 0) {
            connectionManagerBuilder.setDefaultConnectionConfig(ConnectionConfig.custom().setSocketTimeout(connectionTimeout, TimeUnit.MILLISECONDS).setConnectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS).build());
        }
        if (config instanceof ApacheHttpClientConfig) {
            int maxPerRoute;
            ApacheHttpClientConfig apacheHttpClientConfig = (ApacheHttpClientConfig)config;
            int maxTotal = apacheHttpClientConfig.getMaxTotal();
            if (maxTotal > 0) {
                connectionManagerBuilder.setMaxConnTotal(maxTotal);
            }
            if ((maxPerRoute = apacheHttpClientConfig.getMaxPerRoute()) > 0) {
                connectionManagerBuilder.setMaxConnPerRoute(maxPerRoute);
            }
        }
        return connectionManagerBuilder.build();
    }

    private static RequestConfig buildRequestConfig(Request request) {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        int maxRedirects = request.maxRedirects();
        if (maxRedirects > 0) {
            requestConfigBuilder.setMaxRedirects(maxRedirects);
        } else {
            requestConfigBuilder.setRedirectsEnabled(false);
        }
        return requestConfigBuilder.build();
    }

    private static RequestConfig buildDefaultRequestConfig(ClientConfig config) {
        int readTimeout;
        int connectionTimeout = config.getConnectionTimeout();
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (connectionTimeout > 0) {
            requestConfigBuilder.setConnectionRequestTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        }
        if ((readTimeout = config.getReadTimeout()) > 0) {
            requestConfigBuilder.setResponseTimeout((long)readTimeout, TimeUnit.MILLISECONDS);
        }
        if (config instanceof ApacheHttpClientConfig) {
            requestConfigBuilder.setMaxRedirects(((ApacheHttpClientConfig)config).getMaxRedirects());
        }
        return requestConfigBuilder.build();
    }

    private static void setProxy(HttpClientBuilder clientBuilder, ClientConfig config) {
        if (null == config) {
            return;
        }
        ProxyInfo proxy = config.getProxy();
        if (null != proxy) {
            clientBuilder.setProxySelector(proxy.getProxySelector());
            PasswordAuthentication auth = proxy.getAuth();
            if (null != auth) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(new HttpHost(proxy.getAuthHost(), proxy.getAuthPort())), (Credentials)new UsernamePasswordCredentials(auth.getUserName(), auth.getPassword()));
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
        }
    }
}

