/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.body;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import top.redscorpion.core.net.url.UrlQuery;
import top.redscorpion.core.util.RsByte;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.http.client.body.AbstractFormBody;
import top.redscorpion.http.meta.ContentType;

public class UrlEncodedFormBody
extends AbstractFormBody<UrlEncodedFormBody> {
    private byte[] content;

    public static UrlEncodedFormBody of(Map<String, Object> form, Charset charset) {
        return new UrlEncodedFormBody(form, charset);
    }

    public UrlEncodedFormBody(Map<String, Object> form, Charset charset) {
        super(form, charset);
    }

    @Override
    public UrlEncodedFormBody form(String name, Object value) {
        if (null != this.content) {
            this.content = null;
        }
        return (UrlEncodedFormBody)super.form(name, value);
    }

    @Override
    public void write(OutputStream out) {
        RsIo.write(out, this.getGeneratedBytes());
    }

    @Override
    public String contentType() {
        return ContentType.FORM_URLENCODED.toString(this.charset);
    }

    @Override
    public long contentLength() {
        return this.getGeneratedBytes().length;
    }

    private byte[] getGeneratedBytes() {
        if (null == this.content) {
            this.content = RsByte.toBytes(UrlQuery.of(this.form, UrlQuery.EncodeMode.FORM_URL_ENCODED).build(this.charset), this.charset);
        }
        return this.content;
    }
}

