/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.body;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import top.redscorpion.core.io.stream.FastByteArrayOutputStream;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsString;

public interface HttpBody {
    public void write(OutputStream var1);

    public String contentType();

    default public long contentLength() {
        return -1L;
    }

    default public String contentType(Charset charset) {
        String contentType = this.contentType();
        if (null == contentType) {
            return null;
        }
        String charsetName = charset.name();
        if (RsString.endWithIgnoreCase(contentType, charsetName) || RsString.containsIgnoreCase(contentType, "boundary=")) {
            return contentType;
        }
        if (RsString.containsIgnoreCase(contentType, ";charset=")) {
            contentType = RsString.subBefore((CharSequence)contentType, ";charset=", true);
        }
        return contentType + ";charset=" + charset.name();
    }

    default public void writeClose(OutputStream out) {
        try {
            this.write(out);
        }
        catch (Throwable throwable) {
            RsIo.closeQuietly(out);
            throw throwable;
        }
        RsIo.closeQuietly(out);
    }

    default public InputStream getStream() {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        this.writeClose(out);
        return RsIo.toStream(out);
    }

    default public byte[] getBytes() {
        InputStream bodyStream = this.getStream();
        if (bodyStream == null) {
            return null;
        }
        return RsIo.readBytes(bodyStream);
    }
}

