/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.util.RsConvert;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.HttpException;
import top.redscorpion.http.client.body.ResponseBody;
import top.redscorpion.http.meta.HeaderName;
import top.redscorpion.http.meta.RsContentType;
import top.redscorpion.http.meta.RsHttpHeader;

public interface Response
extends Closeable {
    public int getStatus();

    public String header(String var1);

    public Map<String, List<String>> headers();

    default public Charset charset() {
        return RsContentType.getCharset(this.header(HeaderName.CONTENT_TYPE));
    }

    public InputStream bodyStream();

    public Response sync();

    public ResponseBody body();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public String bodyStr() throws HttpException {
        try (ResponseBody body = this.body();){
            String string = body.getString();
            return string;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public byte[] bodyBytes() {
        try (ResponseBody body = this.body();){
            byte[] byArray = null == body ? null : body.getBytes();
            return byArray;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    default public boolean isOk() {
        int status = this.getStatus();
        return status >= 200 && status < 300;
    }

    default public String header(HeaderName name) {
        if (null == name) {
            return null;
        }
        return this.header(name.toString());
    }

    default public List<String> headerList(String name) {
        return RsHttpHeader.headerList(this.headers(), name);
    }

    default public String contentEncoding() {
        return this.header(HeaderName.CONTENT_ENCODING);
    }

    default public long contentLength() {
        long contentLength = RsConvert.toLong(this.header(HeaderName.CONTENT_LENGTH), -1L);
        if (contentLength > 0L && (this.isChunked() || RsString.isNotBlank(this.contentEncoding()))) {
            contentLength = -1L;
        }
        return contentLength;
    }

    default public boolean isChunked() {
        return "Chunked".equalsIgnoreCase(this.header(HeaderName.TRANSFER_ENCODING));
    }

    default public String getCookieStr() {
        return this.header(HeaderName.SET_COOKIE);
    }

    default public String getFileNameFromDisposition(String paramName) {
        return RsHttpHeader.getFileNameFromDisposition(this.headers(), paramName);
    }

    default public void then(Consumer<Response> consumer) {
        consumer.accept(this);
    }
}

