/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.extra.setting;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import top.redscorpion.core.io.LineReader;
import top.redscorpion.core.io.resource.Resource;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsRegular;
import top.redscorpion.core.util.RsSplit;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsSystem;
import top.redscorpion.extra.setting.GroupedMap;
import top.redscorpion.log.Log;

public class SettingLoader {
    private static final Log log = Log.get();
    private static final char COMMENT_FLAG_PRE = '#';
    private final Charset charset;
    private final boolean isUseVariable;
    private char assignFlag = (char)61;
    private String varRegex = "\\$\\{(.*?)\\}";
    private ValueEditor valueEditor;

    public SettingLoader(Charset charset, boolean isUseVariable) {
        this.charset = charset;
        this.isUseVariable = isUseVariable;
    }

    public SettingLoader setVarRegex(String regex) {
        this.varRegex = regex;
        return this;
    }

    public SettingLoader setAssignFlag(char assignFlag) {
        this.assignFlag = assignFlag;
        return this;
    }

    public SettingLoader setValueEditor(ValueEditor valueEditor) {
        this.valueEditor = valueEditor;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupedMap load(Resource resource) {
        GroupedMap groupedMap;
        if (resource == null) {
            throw new NullPointerException("Null setting url define!");
        }
        log.debug("Load setting file [{}]", resource);
        InputStream settingStream = null;
        try {
            settingStream = resource.getStream();
            groupedMap = this.load(settingStream);
        }
        catch (Exception e) {
            GroupedMap groupedMap2;
            try {
                log.error(e, "Load setting error!", new Object[0]);
                groupedMap2 = new GroupedMap();
            }
            catch (Throwable throwable) {
                RsIo.closeQuietly(settingStream);
                throw throwable;
            }
            RsIo.closeQuietly(settingStream);
            return groupedMap2;
        }
        RsIo.closeQuietly(settingStream);
        return groupedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized GroupedMap load(InputStream settingStream) throws IOException {
        GroupedMap groupedMap = new GroupedMap();
        LineReader reader = null;
        try {
            String line;
            reader = new LineReader(settingStream, this.charset);
            String group = null;
            while ((line = reader.readLine()) != null) {
                if (RsString.isBlank(line = RsString.trim(line)) || RsString.startWith((CharSequence)line, '#')) continue;
                if (RsString.isWrap((CharSequence)line, '[', ']')) {
                    group = RsString.trim(line.substring(1, line.length() - 1));
                    continue;
                }
                String[] keyValue = RsSplit.split(line, String.valueOf(this.assignFlag), 2, true, false).toArray(new String[0]);
                if (keyValue.length < 2) continue;
                String key = RsString.trim(keyValue[0]);
                String value = keyValue[1];
                if (null != this.valueEditor) {
                    value = this.valueEditor.edit(group, key, value);
                }
                if (this.isUseVariable) {
                    value = this.replaceVar(groupedMap, group, value);
                }
                groupedMap.put(group, key, value);
            }
        }
        catch (Throwable throwable) {
            RsIo.closeQuietly(reader);
            throw throwable;
        }
        RsIo.closeQuietly(reader);
        return groupedMap;
    }

    public void store(GroupedMap groupedMap, String absolutePath) {
        this.store(groupedMap, RsFile.touch(absolutePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(GroupedMap groupedMap, File file) {
        Assert.notNull(file, "File to store must be not null !", new Object[0]);
        log.debug("Store Setting to [{}]...", file.getAbsolutePath());
        PrintWriter writer = null;
        try {
            writer = RsFile.getPrintWriter(file, this.charset, false);
            this.store(groupedMap, writer);
        }
        catch (Throwable throwable) {
            RsIo.closeQuietly(writer);
            throw throwable;
        }
        RsIo.closeQuietly(writer);
    }

    private synchronized void store(GroupedMap groupedMap, PrintWriter writer) {
        for (Map.Entry<String, LinkedHashMap<String, String>> groupEntry : groupedMap.entrySet()) {
            writer.println(RsString.format("{}{}{}", Character.valueOf('['), groupEntry.getKey(), Character.valueOf(']')));
            for (Map.Entry<String, String> entry : groupEntry.getValue().entrySet()) {
                writer.println(RsString.format("{} {} {}", entry.getKey(), Character.valueOf(this.assignFlag), entry.getValue()));
            }
        }
    }

    private String replaceVar(GroupedMap groupedMap, String group, String value) {
        Set vars = RsRegular.findAll(this.varRegex, (CharSequence)value, 0, new HashSet());
        for (String var : vars) {
            List<String> groupAndKey;
            String key = RsRegular.get(this.varRegex, (CharSequence)var, 1);
            if (!RsString.isNotBlank(key)) continue;
            String varValue = groupedMap.get(group, key);
            if (null == varValue && (groupAndKey = RsSplit.split(key, ".", 2, true, false)).size() > 1) {
                varValue = groupedMap.get(groupAndKey.get(0), groupAndKey.get(1));
            }
            if (null == varValue) {
                varValue = RsSystem.get(key);
            }
            if (null == varValue) continue;
            value = value.replace(var, varValue);
        }
        return value;
    }

    @FunctionalInterface
    public static interface ValueEditor {
        public String edit(String var1, String var2, String var3);
    }
}

