/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.time.ZoneId;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsObject;

public class RsZone {
    public static final TimeZone ZONE_UTC = TimeZone.getTimeZone("UTC");
    public static final ZoneId ZONE_ID_UTC = ZONE_UTC.toZoneId();

    public static TimeZone toTimeZone(ZoneId zoneId) {
        if (null == zoneId) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(zoneId);
    }

    public static ZoneId toZoneId(TimeZone timeZone) {
        if (null == timeZone) {
            return ZoneId.systemDefault();
        }
        return timeZone.toZoneId();
    }

    public static TimeZone getTimeZoneByOffset(int rawOffset, TimeUnit timeUnit) {
        String id = RsZone.getAvailableID(rawOffset, timeUnit);
        return null == id ? null : TimeZone.getTimeZone(id);
    }

    public static String getAvailableID(int rawOffset, TimeUnit timeUnit) {
        String[] availableIDs = TimeZone.getAvailableIDs((int)RsObject.defaultIfNull(timeUnit, TimeUnit.MILLISECONDS).toMillis(rawOffset));
        return RsArray.isEmpty(availableIDs) ? null : availableIDs[0];
    }
}

