/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.lang.reflect.Type;
import java.util.Set;
import top.redscorpion.core.util.RsSet;
import top.redscorpion.core.util.RsString;

public class RsBoolean {
    private static final Set<String> TRUE_SET = RsSet.of("true", "yes", "y", "t", "ok", "1", "on", "\u662f", "\u5bf9", "\u771f", "\u5c0d", "\u221a");

    public static boolean toBoolean(String valueStr) {
        if (RsString.isNotBlank(valueStr)) {
            return TRUE_SET.contains(valueStr.trim().toLowerCase());
        }
        return false;
    }

    public static int toInt(boolean value) {
        return value ? 1 : 0;
    }

    public static Integer toInteger(boolean value) {
        return RsBoolean.toInt(value);
    }

    public static char toChar(boolean value) {
        return (char)RsBoolean.toInt(value);
    }

    public static Character toCharacter(boolean value) {
        return Character.valueOf(RsBoolean.toChar(value));
    }

    public static byte toByte(boolean value) {
        return (byte)RsBoolean.toInt(value);
    }

    public static Byte toByteObj(boolean value) {
        return RsBoolean.toByte(value);
    }

    public static long toLong(boolean value) {
        return RsBoolean.toInt(value);
    }

    public static Long toLongObj(boolean value) {
        return RsBoolean.toLong(value);
    }

    public static short toShort(boolean value) {
        return (short)RsBoolean.toInt(value);
    }

    public static Short toShortObj(boolean value) {
        return RsBoolean.toShort(value);
    }

    public static float toFloat(boolean value) {
        return RsBoolean.toInt(value);
    }

    public static Float toFloatObj(boolean value) {
        return Float.valueOf(RsBoolean.toFloat(value));
    }

    public static double toDouble(boolean value) {
        return RsBoolean.toInt(value);
    }

    public static Double toDoubleObj(boolean value) {
        return RsBoolean.toDouble(value);
    }

    public static boolean isBoolean(Type type) {
        return type == Boolean.class || type == Boolean.TYPE;
    }
}

