/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.reflect.method;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.reflect.Invoker;
import top.redscorpion.core.reflect.method.RsMethod;
import top.redscorpion.core.reflect.method.RsMethodHandle;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsModifier;
import top.redscorpion.core.util.RsReflect;
import top.redscorpion.core.util.RsType;

public class MethodInvoker
implements Invoker {
    private final Method method;
    private final Type[] paramTypes;
    private final Class<?>[] paramTypeClasses;
    private final Type type;
    private final Class<?> typeClass;
    private boolean checkArgs;

    public static MethodInvoker of(Method method) {
        return new MethodInvoker(method);
    }

    public MethodInvoker(Method method) {
        this.method = (Method)RsReflect.setAccessible((AccessibleObject)Assert.notNull(method));
        this.paramTypes = RsType.getParamTypes(method);
        this.paramTypeClasses = method.getParameterTypes();
        if (this.paramTypes.length == 1) {
            this.type = this.paramTypes[0];
            this.typeClass = this.paramTypeClasses[0];
        } else {
            this.type = method.getReturnType();
            this.typeClass = method.getReturnType();
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Type[] getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public MethodInvoker setCheckArgs(boolean checkArgs) {
        this.checkArgs = checkArgs;
        return this;
    }

    @Override
    public <T> T invoke(Object target, Object ... args) throws RsException {
        Method method;
        if (this.checkArgs) {
            this.checkArgs(args);
        }
        if (RsModifier.isStatic(method = this.method)) {
            target = null;
        }
        Object[] actualArgs = RsMethod.actualArgs(method, args);
        try {
            return RsMethodHandle.invokeExact(target, method, actualArgs);
        }
        catch (Exception e) {
            try {
                return (T)method.invoke(target, actualArgs);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RsException(ex);
            }
        }
    }

    public <T> T invokeStatic(Object ... args) throws RsException {
        return this.invoke(null, args);
    }

    private void checkArgs(Object[] args) {
        Class<?>[] paramTypeClasses = this.paramTypeClasses;
        if (null != args) {
            Assert.isTrue(args.length == paramTypeClasses.length, "Params length [{}] is not fit for param length [{}] of method !", args.length, paramTypeClasses.length);
            for (int i = 0; i < args.length; ++i) {
                Class<?> type = paramTypeClasses[i];
                if (!type.isPrimitive() || null != args[i]) continue;
                args[i] = RsClass.getDefaultValue(type);
            }
        }
    }
}

