/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.reflect;

import java.lang.reflect.Constructor;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.map.reference.WeakConcurrentMap;
import top.redscorpion.core.reflect.creator.DefaultObjectCreator;
import top.redscorpion.core.reflect.creator.PossibleObjectCreator;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsReflect;

public class RsConstructor {
    private static final WeakConcurrentMap<Class<?>, Constructor<?>[]> CONSTRUCTORS_CACHE = new WeakConcurrentMap();

    static synchronized void clearCache() {
        CONSTRUCTORS_CACHE.clear();
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<T>[] constructors;
        if (null == clazz) {
            return null;
        }
        for (Constructor<T> constructor : constructors = RsConstructor.getConstructors(clazz)) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!RsClass.isAllAssignableFrom(pts, parameterTypes)) continue;
            RsReflect.setAccessible(constructor);
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T>[] getConstructors(Class<T> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return CONSTRUCTORS_CACHE.computeIfAbsent(beanClass, key -> RsConstructor.getConstructorsDirectly(beanClass));
    }

    public static Constructor<?>[] getConstructorsDirectly(Class<?> beanClass) throws SecurityException {
        return beanClass.getDeclaredConstructors();
    }

    public static <T> T newInstance(String clazz) throws RsException {
        return DefaultObjectCreator.of(clazz).create();
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) throws RsException {
        return DefaultObjectCreator.of(clazz, params).create();
    }

    public static <T> T newInstanceIfPossible(Class<T> type) {
        return PossibleObjectCreator.of(type).create();
    }
}

