/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io.stream;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import top.redscorpion.core.io.buffer.FastByteBuffer;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsObject;

public class FastByteArrayOutputStream
extends OutputStream {
    private final FastByteBuffer buffer;

    public static FastByteArrayOutputStream of(InputStream in, int limit) {
        int length = RsIo.length(in);
        if (length < 0 || length > limit) {
            length = limit;
        }
        if (length < 0) {
            length = 8192;
        }
        return new FastByteArrayOutputStream(length);
    }

    public FastByteArrayOutputStream() {
        this(8192);
    }

    public FastByteArrayOutputStream(int size) {
        this.buffer = new FastByteBuffer(size);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.buffer.append(b, off, len);
    }

    @Override
    public void write(int b) {
        this.buffer.append((byte)b);
    }

    @Override
    public void close() {
    }

    public byte[] toByteArray() {
        return this.buffer.toArray();
    }

    public byte[] toByteArray(int start, int len) {
        return this.buffer.toArray(start, len);
    }

    public byte[] toByteArrayZeroCopyIfPossible() {
        return this.buffer.toArrayZeroCopyIfPossible();
    }

    public String toString() {
        return this.toString(RsCharset.defaultCharset());
    }

    public String toString(Charset charset) {
        return new String(this.toByteArray(), RsObject.defaultIfNull(charset, RsCharset::defaultCharset));
    }
}

