/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.date.format.parser;

import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import top.redscorpion.core.date.DateException;
import top.redscorpion.core.date.format.DateBasic;
import top.redscorpion.core.date.format.parser.DateParser;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsDate;

public interface PositionDateParser
extends DateParser,
DateBasic {
    public boolean parse(CharSequence var1, ParsePosition var2, Calendar var3);

    default public Date parse(CharSequence source, ParsePosition pos) {
        return this.parseCalendar(source, pos, RsDate.isGlobalLenient()).getTime();
    }

    default public Calendar parseCalendar(CharSequence source, ParsePosition pos, boolean lenient) {
        Assert.notBlank(source, "Date str must be not blank!", new Object[0]);
        Calendar calendar = Calendar.getInstance(this.getTimeZone(), this.getLocale());
        calendar.clear();
        calendar.setLenient(lenient);
        if (this.parse(source.toString(), pos, calendar)) {
            return calendar;
        }
        throw new DateException("Parse [{}] with format [{}] error, at: {}", source, this.getPattern(), pos.getErrorIndex());
    }
}

