/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.data.desensitize;

import java.util.Map;
import top.redscorpion.core.data.desensitize.DesensitizeHandler;
import top.redscorpion.core.util.RsString;

public class DesensitizeManager {
    public static final char DEFAULT_MASK_CHAR = '*';
    public static final DesensitizeManager EMPTY = new DesensitizeManager(null);
    private final Map<String, DesensitizeHandler> handlerMap;
    private final char maskChar;

    public DesensitizeManager(Map<String, DesensitizeHandler> handlerMap) {
        this(handlerMap, '*');
    }

    public DesensitizeManager(Map<String, DesensitizeHandler> handlerMap, char maskChar) {
        this.handlerMap = handlerMap;
        this.maskChar = maskChar;
    }

    public String firstMask(CharSequence str) {
        if (RsString.isBlank(str)) {
            return "";
        }
        return RsString.replaceByCodePoint(str, 1, str.length(), this.maskChar);
    }

    public String idCard(CharSequence idCard, int front, int end) {
        if (RsString.isBlank(idCard)) {
            return "";
        }
        if (front + end > idCard.length()) {
            return "";
        }
        if (front < 0 || end < 0) {
            return "";
        }
        return RsString.replaceByCodePoint(idCard, front, idCard.length() - end, this.maskChar);
    }

    public String telephone(CharSequence num) {
        if (RsString.isBlank(num)) {
            return "";
        }
        return RsString.replaceByCodePoint(num, 4, num.length() - 2, this.maskChar);
    }

    public String mobile(CharSequence num) {
        if (RsString.isBlank(num)) {
            return "";
        }
        return RsString.replaceByCodePoint(num, 3, num.length() - 4, this.maskChar);
    }

    public String address(CharSequence address, int sensitiveSize) {
        if (RsString.isBlank(address)) {
            return "";
        }
        int length = address.length();
        return RsString.replaceByCodePoint(address, length - sensitiveSize, length, this.maskChar);
    }

    public String email(CharSequence email) {
        if (RsString.isBlank(email)) {
            return "";
        }
        int index = RsString.indexOf(email, '@');
        if (index <= 1) {
            return email.toString();
        }
        return RsString.replaceByCodePoint(email, 1, index, this.maskChar);
    }

    public String password(CharSequence password) {
        if (RsString.isBlank(password)) {
            return "";
        }
        return RsString.repeat(this.maskChar, 10);
    }

    public String bankCard(CharSequence bankCardNo) {
        if (RsString.isBlank(bankCardNo)) {
            return RsString.toStringOrNull(bankCardNo);
        }
        if ((bankCardNo = RsString.cleanBlank(bankCardNo)).length() < 9) {
            return bankCardNo.toString();
        }
        int length = bankCardNo.length();
        int endLength = length % 4 == 0 ? 4 : length % 4;
        int midLength = length - 4 - endLength;
        StringBuilder buf = new StringBuilder();
        buf.append(bankCardNo, 0, 4);
        for (int i = 0; i < midLength; ++i) {
            if (i % 4 == 0) {
                buf.append(' ');
            }
            buf.append(this.maskChar);
        }
        buf.append(' ').append(bankCardNo, length - endLength, length);
        return buf.toString();
    }

    public String ipv4(CharSequence ipv4) {
        return RsString.subBefore(ipv4, '.', false) + RsString.repeat("." + this.maskChar, 3);
    }

    public String ipv6(CharSequence ipv6) {
        return RsString.subBefore(ipv6, ':', false) + RsString.repeat(":" + this.maskChar, 7);
    }

    public String text(CharSequence str, int front, int end) {
        if (RsString.isBlank(str)) {
            return "";
        }
        if (str.length() == 1) {
            return RsString.repeat(this.maskChar, 10);
        }
        if (front >= str.length()) {
            return RsString.subPre(str, 1) + RsString.repeat(this.maskChar, 9);
        }
        if (front + end >= str.length()) {
            return RsString.replaceByCodePoint(str, front, str.length(), this.maskChar);
        }
        if (front < 0 && end < 0) {
            return RsString.replaceByCodePoint(str, 1, str.length(), this.maskChar);
        }
        if (front < 0 && end >= 0) {
            return RsString.replaceByCodePoint(str, 0, str.length() - end, this.maskChar);
        }
        if (front >= 0 && end < 0) {
            return RsString.replaceByCodePoint(str, front, str.length(), this.maskChar);
        }
        return RsString.replaceByCodePoint(str, front, str.length() - end, this.maskChar);
    }

    public String text(CharSequence str, int front, int end, int setMaxLength) {
        if (RsString.isBlank(str)) {
            return "";
        }
        int len = setMaxLength;
        int maxLen = setMaxLength;
        int strLen = str.length();
        if (len <= 0) {
            len = str.length();
            maxLen = 10;
        }
        if (len < strLen) {
            strLen = len;
        }
        if (strLen == 1) {
            return RsString.repeat(this.maskChar, maxLen);
        }
        if (front >= strLen) {
            return RsString.subPre(str, 1) + RsString.repeat(this.maskChar, setMaxLength - 1);
        }
        if (front + end >= strLen) {
            return RsString.subPre(str, front) + RsString.repeat(this.maskChar, setMaxLength - front);
        }
        if (front < 0 && end < 0) {
            return RsString.subPre(str, 1) + RsString.repeat(this.maskChar, setMaxLength - 1);
        }
        if (front < 0 && end >= 0) {
            return RsString.repeat(this.maskChar, setMaxLength - end) + RsString.subSuf(str, -end);
        }
        if (front >= 0 && end < 0) {
            return RsString.subPre(str, front) + RsString.repeat(this.maskChar, setMaxLength - front);
        }
        return RsString.subPre(str, front) + RsString.repeat(this.maskChar, setMaxLength - front - end) + RsString.subSuf(str, -end);
    }
}

