/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;
import top.redscorpion.core.convert.AbstractConverterWithRoot;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.convert.Converter;
import top.redscorpion.core.lang.tuple.Triple;
import top.redscorpion.core.reflect.AbstractTypeReference;
import top.redscorpion.core.util.RsBean;
import top.redscorpion.core.util.RsType;

public class TripleConverter
extends AbstractConverterWithRoot
implements Serializable {
    private static final long serialVersionUID = 1L;

    public TripleConverter(Converter rootConverter) {
        super(rootConverter);
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (targetType instanceof AbstractTypeReference) {
            targetType = ((AbstractTypeReference)targetType).getType();
        }
        Type leftType = RsType.getTypeArgument(targetType, 0);
        Type middileType = RsType.getTypeArgument(targetType, 1);
        Type rightType = RsType.getTypeArgument(targetType, 2);
        return this.convert(leftType, middileType, rightType, value);
    }

    public Triple<?, ?, ?> convert(Type leftType, Type middleType, Type rightType, Object value) throws ConvertException {
        Map<String, Object> map = null;
        if (value instanceof Map) {
            map = (Map<String, Object>)value;
        } else if (RsBean.isReadableBean(value.getClass())) {
            map = RsBean.toBeanMap(value);
        }
        if (null != map) {
            return this.mapToTriple(leftType, middleType, rightType, map);
        }
        throw new ConvertException("Unsupported to map from [{}] of type: {}", value, value.getClass().getName());
    }

    private Triple<?, ?, ?> mapToTriple(Type leftType, Type middleType, Type rightType, Map map) {
        Object left = map.get("left");
        Object middle = map.get("middle");
        Object right = map.get("right");
        return Triple.of(RsType.isUnknown(leftType) ? left : this.rootConverter.convert(leftType, left), RsType.isUnknown(middleType) ? middle : this.rootConverter.convert(middleType, middle), RsType.isUnknown(rightType) ? right : this.rootConverter.convert(rightType, right));
    }
}

