/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.bean.copier;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.UnaryOperator;
import top.redscorpion.core.bean.BeanDesc;
import top.redscorpion.core.bean.PropDesc;
import top.redscorpion.core.convert.Converter;
import top.redscorpion.core.lang.mutable.MutableEntry;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsConvert;
import top.redscorpion.core.util.RsString;

public class CopyOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Class<?> editable;
    protected boolean ignoreNullValue;
    protected boolean ignoreError;
    protected boolean ignoreCase;
    private BiPredicate<Field, Object> propertiesFilter;
    protected UnaryOperator<MutableEntry<Object, Object>> fieldEditor;
    protected boolean transientSupport = true;
    protected boolean override = true;
    protected boolean autoTransCamelCase = true;
    protected Class<BeanDesc> beanDescClass;
    protected Converter converter = (type, value) -> RsConvert.convertWithCheck(type, value, null, this.ignoreError);

    public static CopyOptions of() {
        return new CopyOptions();
    }

    public CopyOptions setIgnoreNullValue(boolean ignoreNullVall) {
        this.ignoreNullValue = ignoreNullVall;
        return this;
    }

    public CopyOptions setPropertiesFilter(BiPredicate<Field, Object> propertiesFilter) {
        this.propertiesFilter = propertiesFilter;
        return this;
    }

    public CopyOptions setIgnoreProperties(String ... ignoreProperties) {
        return this.setPropertiesFilter((field, o) -> {
            if (this.ignoreCase) {
                return !RsArray.containsIgnoreCase(ignoreProperties, field.getName());
            }
            return !RsArray.contains(ignoreProperties, field.getName());
        });
    }

    public CopyOptions setIgnoreError(boolean ignoreError) {
        this.ignoreError = ignoreError;
        return this;
    }

    public CopyOptions setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    public CopyOptions setFieldEditor(UnaryOperator<MutableEntry<Object, Object>> editor) {
        this.fieldEditor = editor;
        return this;
    }

    protected MutableEntry<Object, Object> editField(Object key, Object value) {
        MutableEntry entry = new MutableEntry(key, value);
        return null != this.fieldEditor ? (MutableEntry)this.fieldEditor.apply(entry) : entry;
    }

    protected Object convertField(Type targetType, Object fieldValue) {
        return null != this.converter ? this.converter.convert(targetType, fieldValue) : fieldValue;
    }

    protected boolean testPropertyFilter(Field field, Object value) {
        return null == this.propertiesFilter || this.propertiesFilter.test(field, value);
    }

    protected PropDesc findPropDesc(Map<String, PropDesc> targetPropDescMap, String sKeyStr) {
        String camelCaseKey;
        PropDesc propDesc = targetPropDescMap.get(sKeyStr);
        if (null == propDesc && this.autoTransCamelCase && !RsString.equals(sKeyStr, camelCaseKey = RsString.toCamelCase(sKeyStr))) {
            propDesc = targetPropDescMap.get(camelCaseKey);
        }
        return propDesc;
    }
}

