/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.style;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellReference;
import top.redscorpion.poi.excel.style.RsStyle;
import top.redscorpion.poi.excel.style.StyleSet;

public class DefaultStyleSet
implements StyleSet,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Workbook workbook;
    private final CellStyle headCellStyle;
    private final CellStyle cellStyle;
    private final CellStyle cellStyleForNumber;
    private final CellStyle cellStyleForDate;
    private final CellStyle cellStyleForHyperlink;

    public DefaultStyleSet(Workbook workbook) {
        this.workbook = workbook;
        this.headCellStyle = RsStyle.createHeadCellStyle(workbook);
        this.cellStyle = RsStyle.createDefaultCellStyle(workbook);
        this.cellStyleForNumber = RsStyle.cloneCellStyle(workbook, this.cellStyle);
        this.cellStyleForNumber.setDataFormat((short)0);
        this.cellStyleForDate = RsStyle.cloneCellStyle(workbook, this.cellStyle);
        this.cellStyleForDate.setDataFormat((short)22);
        this.cellStyleForHyperlink = RsStyle.cloneCellStyle(workbook, this.cellStyle);
        Font font = workbook.createFont();
        font.setUnderline((byte)1);
        font.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
        this.cellStyleForHyperlink.setFont(font);
    }

    @Override
    public CellStyle getStyleFor(CellReference reference, Object cellValue, boolean isHeader) {
        CellStyle style = null;
        if (isHeader && null != this.headCellStyle) {
            style = this.headCellStyle;
        } else if (null != this.cellStyle) {
            style = this.cellStyle;
        }
        if (cellValue instanceof Date || cellValue instanceof TemporalAccessor || cellValue instanceof Calendar) {
            if (null != this.cellStyleForDate) {
                style = this.cellStyleForDate;
            }
        } else if (cellValue instanceof Number) {
            if ((cellValue instanceof Double || cellValue instanceof Float || cellValue instanceof BigDecimal) && null != this.cellStyleForNumber) {
                style = this.cellStyleForNumber;
            }
        } else if (cellValue instanceof Hyperlink && null != this.cellStyleForHyperlink) {
            style = this.cellStyleForHyperlink;
        }
        return style;
    }

    public CellStyle getHeadCellStyle() {
        return this.headCellStyle;
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public CellStyle getCellStyleForNumber() {
        return this.cellStyleForNumber;
    }

    public CellStyle getCellStyleForDate() {
        return this.cellStyleForDate;
    }

    public CellStyle getCellStyleForHyperlink() {
        return this.cellStyleForHyperlink;
    }

    public DefaultStyleSet setBorder(BorderStyle borderSize, IndexedColors colorIndex) {
        RsStyle.setBorder(this.headCellStyle, borderSize, colorIndex);
        RsStyle.setBorder(this.cellStyle, borderSize, colorIndex);
        RsStyle.setBorder(this.cellStyleForNumber, borderSize, colorIndex);
        RsStyle.setBorder(this.cellStyleForDate, borderSize, colorIndex);
        RsStyle.setBorder(this.cellStyleForHyperlink, borderSize, colorIndex);
        return this;
    }

    public DefaultStyleSet setAlign(HorizontalAlignment halign, VerticalAlignment valign) {
        RsStyle.setAlign(this.headCellStyle, halign, valign);
        RsStyle.setAlign(this.cellStyle, halign, valign);
        RsStyle.setAlign(this.cellStyleForNumber, halign, valign);
        RsStyle.setAlign(this.cellStyleForDate, halign, valign);
        RsStyle.setAlign(this.cellStyleForHyperlink, halign, valign);
        return this;
    }

    public DefaultStyleSet setBackgroundColor(IndexedColors backgroundColor, boolean withHeadCell) {
        if (withHeadCell) {
            RsStyle.setColor(this.headCellStyle, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        }
        RsStyle.setColor(this.cellStyle, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        RsStyle.setColor(this.cellStyleForNumber, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        RsStyle.setColor(this.cellStyleForDate, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        RsStyle.setColor(this.cellStyleForHyperlink, backgroundColor, FillPatternType.SOLID_FOREGROUND);
        return this;
    }

    public DefaultStyleSet setFont(short color, short fontSize, String fontName, boolean ignoreHead) {
        Font font = RsStyle.createFont(this.workbook, color, fontSize, fontName);
        return this.setFont(font, ignoreHead);
    }

    public DefaultStyleSet setFont(Font font, boolean ignoreHead) {
        if (!ignoreHead) {
            this.headCellStyle.setFont(font);
        }
        this.cellStyle.setFont(font);
        this.cellStyleForNumber.setFont(font);
        this.cellStyleForDate.setFont(font);
        this.cellStyleForHyperlink.setFont(font);
        return this;
    }

    public DefaultStyleSet setWrapText() {
        this.cellStyle.setWrapText(true);
        this.cellStyleForNumber.setWrapText(true);
        this.cellStyleForDate.setWrapText(true);
        this.cellStyleForHyperlink.setWrapText(true);
        return this;
    }
}

